%define oname pymemcache

Name: python3-module-%oname
Version: 1.4.3
Release: alt2
Summary: A comprehensive, fast, pure Python memcached client
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.python.org/pypi/pymemcache/

# https://github.com/pinterest/pymemcache.git
Source: %name-%version.tar
BuildArch: noarch
Patch1: %oname-%version-alt-tests.patch

BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-module-six python3-module-nose
BuildRequires: python3-module-mock
BuildRequires: python3-module-pytest

%description
pymemcache supports the following features:

* Complete implementation of the memcached text protocol.
* Configurable timeouts for socket connect and send/recv calls.
* Access to the "noreply" flag, which can significantly increase the
  speed of writes.
* Flexible, simple approach to serialization and deserialization.
* The (optional) ability to treat network and memcached errors as cache
  misses.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
pymemcache supports the following features:

* Complete implementation of the memcached text protocol.
* Configurable timeouts for socket connect and send/recv calls.
* Access to the "noreply" flag, which can significantly increase the
  speed of writes.
* Flexible, simple approach to serialization and deserialization.
* The (optional) ability to treat network and memcached errors as cache
  misses.

This pakage contains tests for %oname.

%prep
%setup
%patch1 -p1

%build
%python3_build

%install
%python3_install

%check
py.test3

%files
%doc *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/test

%files tests
%python3_sitelibdir/*/test

%changelog
