%define oname pyproj

Name: python3-module-%oname
Version: 1.9.6
Release: alt2
Summary: Pyrex generated python interface to PROJ.4 library
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/pyproj/

# https://github.com/jswhit/pyproj.git
Source: %oname-%version.tar.gz

BuildRequires(pre): rpm-build-python3
BuildRequires: time
BuildRequires: python3-module-Cython
BuildRequires: /usr/bin/2to3

%description
Pyrex generated python interface to PROJ.4 library

Performs cartographic transformations and geodetic computations.

The Proj class can convert from geographic (longitude,latitude) to
native map projection (x,y) coordinates and vice versa, or from one map
projection coordinate system directly to another.

The Geod class can perform forward and inverse geodetic, or Great
Circle, computations. The forward computation involves determining
latitude, longitude and back azimuth of a terminus point given the
latitude and longitude of an initial point, plus azimuth and distance.
The inverse computation involves determining the forward and back
azimuths and distance given the latitudes and longitudes of an initial
and terminus point.

Input coordinates can be given as python arrays, lists/tuples, scalars
or numpy/Numeric/numarray arrays. Optimized for objects that support the
Python buffer protocol (regular python and numpy array objects).

%package tests
Summary: Tests for pyrex generated python interface to PROJ.4 library
Group: Development/Python3
Requires: %name = %version-%release

%description tests
Pyrex generated python interface to PROJ.4 library

Performs cartographic transformations and geodetic computations.

This package contains tests for pyrex generated python interface to
PROJ.4 library.

%prep
%setup

find . -type f -name '*.py' -exec 2to3 -w -n '{}' +

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug

%install
%python3_install
install -d %buildroot%python3_sitelibdir/%oname/test
install -p -m644 test/* %buildroot%python3_sitelibdir/%oname/test
chmod +x %buildroot%python3_sitelibdir/%oname/data/test*

%files
%doc Changelog LICENSE* *.md docs
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/test
%exclude %python3_sitelibdir/%oname/data/test*

%files tests
%python3_sitelibdir/*/test
%python3_sitelibdir/%oname/data/test*

%changelog
