%define oname pyresttest

%def_disable check

Name: python3-module-%oname
Version: 1.7.1
Release: alt1

Summary: Python RESTful API Testing & Microbenchmarking Tool
License: ASLv2.0
Group: Development/Python3
Url: https://pypi.python.org/pypi/pyresttest/
# https://github.com/svanoort/pyresttest.git

Source: %name-%version.tar
Source1: repocop-test-hint:binary:python-module-pyresttest:altlinux-python-test-is-packaged
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-yaml python3-module-pycurl
BuildRequires: python3-module-django-tests python3-module-jsonschema
BuildRequires: python-tools-2to3

%py3_provides %oname


%description
* A simple but powerful REST testing and benchmarking framework
* Minimal dependencies, designed to slot into automated configuration
  management/orchestration tools
* Tests are defined in basic YAML or JSON config files, no code needed
* Logic is written and extensible in Python

%prep
%setup

chmod +x run_tests.sh

find ./ -type f -name '*.py' -exec 2to3 -w -n '{}' +

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%python3_build_debug

%install
%python3_install

%check
sed -i 's|^python|python3|' run_tests.sh
export PYTHONPATH=$PWD
./run_tests.sh

%files
%doc *.md
%_bindir/*
%python3_sitelibdir/*


%changelog
