%define _unpackaged_files_terminate_build 1
%define oname pytest-sugar

%def_with check

Name: python3-module-%oname
Version: 0.9.4
Release: alt1
Summary: Plugin for py.test that shows failures and errors instantly and shows a progress bar
License: BSD
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.org/project/pytest-sugar/

# https://github.com/Frozenball/pytest-sugar.git
Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3-module-packaging >= 14.1
BuildRequires: python3-module-pytest >= 2.9
BuildRequires: python3-module-termcolor >= 1.1.0
BuildRequires: python3-module-pytest-xdist
BuildRequires: python3(tox)
%endif

%py3_provides pytest_sugar

%description
pytest-sugar is a plugin for py.test that changes the default look and
feel of py.test (e.g. progressbar, show tests that fail instantly).

%prep
%setup
%autopatch -p1

%build
%python3_build_debug

%install
%python3_install

%check
export PIP_NO_BUILD_ISOLATION=no
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages -vvr

%files
%doc *.rst
%python3_sitelibdir/*

%changelog
