%define _unpackaged_files_terminate_build 1
%define pkgname requests

%def_with check

Name: python3-module-%pkgname
Version: 2.32.3
Release: alt0.p10.1

Summary: HTTP library, written in Python, for human beings
License: Apache-2.0
Group: Development/Python3

Url: https://pypi.org/project/requests/
VCS: https://github.com/psf/requests
BuildArch: noarch
Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra socks
%pyproject_builddeps_check
%endif

%description
Requests allows you to send HTTP/1.1 requests extremely easily. There's no need
to manually add query strings to your URLs, or to form-encode your POST data.
Keep-alive and HTTP connection pooling are 100%% automatic, thanks to urllib3.

%prep
%setup
%autopatch -p1

# Unbundle the certificate bundle from mozilla.
rm -rf requests/cacert.pem
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile requirements-dev.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra -Wignore -k "not TestTimeout and not test_unicode_header_name" tests

%files
%doc AUTHORS.rst HISTORY.md README.md
%python3_sitelibdir/%pkgname/
%python3_sitelibdir/%{pyproject_distinfo %pkgname}/

%changelog
