%define _unpackaged_files_terminate_build 1

%define oname scikit-learn

%def_disable check

Name: python3-module-%oname
Version: 0.23.2
Release: alt1

Summary: A set of python modules for machine learning and data mining
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.python.org/pypi/scikit-learn/

# https://github.com/scikit-learn/scikit-learn.git
Source: %name-%version.tar
Patch1: %oname-%version-alt-build.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ liblapack-devel xvfb-run
BuildRequires: libgomp-devel
BuildRequires: libnumpy-py3-devel python3-module-numpy-testing python3-module-scipy python3-module-zope python3-module-pytest
BuildRequires: python3-module-six python3-module-joblib python3-module-Cython python3(nose)
BuildRequires: python3(threadpoolctl)

%py3_provides sklearn

%description
scikit-learn is a Python module for machine learning built on top of
SciPy and distributed under the 3-Clause BSD license.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
scikit-learn is a Python module for machine learning built on top of
SciPy and distributed under the 3-Clause BSD license.

This package contains tests for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
scikit-learn is a Python module for machine learning built on top of
SciPy and distributed under the 3-Clause BSD license.

This package contains documentation for %oname.

%prep
%setup
%patch1 -p1

%build
export BLAS=openblas
%python3_build_debug

%install
%python3_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
rm -fR build
%__python3 setup.py build_ext -i
xvfb-run py.test3 -vv

%files
%doc *.md *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/*/*/test*
%exclude %python3_sitelibdir/*/*/*/*/test*

%files tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/*/*/test*
%python3_sitelibdir/*/*/*/*/test*

%files docs
%doc examples doc

%changelog
