%define mname scikits
%define oname %mname.bootstrap

Name: python3-module-%oname
Version: 1.0.1
Release: alt2

Summary: Bootstrap confidence interval estimation routines for SciPy
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.python.org/pypi/scikits.bootstrap/

# https://github.com/cgevans/scikits-bootstrap.git
Source: %name-%version.tar

Patch1: %oname-upstream-numpy-compat.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-numpy python3-module-scipy
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-nose python3-module-pandas
BuildRequires: python3(pyerf)

%py3_provides %oname
%py3_requires %mname numpy scipy


%description
Scikits.bootstrap provides bootstrap confidence interval algorithms for
scipy.

At present, it is rather feature-incomplete and in flux. However, the
functions that have been written should be relatively stable as far as
results.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR
%py3_requires pandas

%description tests
Scikits.bootstrap provides bootstrap confidence interval algorithms for
scipy.

At present, it is rather feature-incomplete and in flux. However, the
functions that have been written should be relatively stable as far as
results.

This package contains tests for %oname.

%prep
%setup
%patch1 -p1

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%python3_build_debug

%install
%python3_install

%if "%python3_sitelibdir" != "%python3_sitelibdir_noarch"
mkdir -p %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* %buildroot%python3_sitelibdir/
%endif

%check
%__python3 setup.py test

%files
%doc LICENSE
%doc *.md
%python3_sitelibdir/%mname/*
%python3_sitelibdir/*.egg-info
%python3_sitelibdir/*-nspkg.pth
%exclude %python3_sitelibdir/%mname/*/test*
%exclude %python3_sitelibdir/%mname/*/*/test*

%files tests
%python3_sitelibdir/%mname/*/test*
%python3_sitelibdir/%mname/*/*/test*


%changelog
