%define _unpackaged_files_terminate_build 1
%define mod_name setuptools_scm
%define pypi_name setuptools-scm
%define tomli %(%__python3 -c 'import sys;print(int(sys.version_info < (3, 11)))')

%def_with check

Name: python3-module-%mod_name
Version: 7.1.0
Release: alt1
Summary: The blessed package to manage your versions by scm tags
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/setuptools-scm/
VCS: https://github.com/pypa/setuptools_scm/
BuildArch: noarch
Source: %name-%version.tar
Patch1: %name-%version-alt.patch

Requires: git-core mercurial
%py3_requires packaging
%py3_requires setuptools
%if %tomli
%py3_requires tomli
%endif

%py3_provides %pypi_name
Provides: python3-module-%pypi_name = %EVR

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3(typing_extensions)
BuildRequires: python3(packaging)

BuildRequires: git-core

%if_with check
# install_requires
BuildRequires: python3(packaging)
BuildRequires: python3(setuptools)
%if %tomli
BuildRequires: python3(tomli)
%endif

BuildRequires: mercurial
BuildRequires: python3(pytest)
BuildRequires: python3(virtualenv)
%endif

%description
setuptools_scm is a simple utility for the setup_requires feature of
setuptools for use in Mercurial and Git based projects.

It uses metadata from the SCM to generate the version of a project and
is able to list the files belonging to that project (which makes the
MANIFEST.in file unnecessary in many cases).

It falls back to PKG-INFO/.hg_archival.txt when necessary.

%prep
%setup
%patch1 -p1

# if build from git source tree
# setuptools_scm implements a file_finders entry point which returns all files
# tracked by SCM. These files will be packaged unless filtered by MANIFEST.in.
git init
git config user.email author@example.com
git config user.name author
git add .
git commit -m 'release'
git tag '%version'

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra

%files
%doc *.rst
%python3_sitelibdir/setuptools_scm/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
