%define _unpackaged_files_terminate_build 1

%define  oname sybil
%def_with check

Name:    python3-module-%oname
Version: 3.0.1
Release: alt1

Summary:  Automated testing for the examples in your documentation.
License: MIT
Group:   Development/Python3
URL:     https://github.com/cjw296/sybil

BuildArch: noarch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
%endif

# https://github.com/cjw296/sybil.git
Source: %name-%version.tar

%description
Automated testing for the examples in your documentation.

%prep
%setup

%build
%python3_build

%install
%python3_install

%check
cat > tox.ini <<'EOF'
[testenv]
commands =
    {envbindir}/pytest {posargs:-vra}
EOF
export PIP_NO_BUILD_ISOLATION=no
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages --console-scripts -vvr -s false --develop

%files
%doc README.rst
%python3_sitelibdir/%oname/
%python3_sitelibdir/%oname-%version-py%_python3_version.egg-info/

%changelog
