%define _unpackaged_files_terminate_build 1
%define pypi_name tox

%def_with check

Name: python3-module-%pypi_name
Version: 3.27.1
Release: alt4

Summary: virtualenv-based automation of test activities
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/tox/
VCS: https://github.com/tox-dev/tox
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
BuildRequires: /proc
%pyproject_builddeps_metadata_extra testing
# used in test_parallel_error_report,
# upstream relies on being run within venv
BuildRequires: python3-module-pip
%endif

%description
Tox as is a generic virtualenv management and test command line tool you
can use for:

* checking your package installs correctly with different Python
  versions and interpreters
* running your tests in each of the environments, configuring your test
  tool of choice
* acting as a frontend to Continuous Integration servers, greatly
  reducing boilerplate and merging CI and shell-based testing.

%prep
%setup
%patch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

pushd %buildroot%_bindir
for i in $(ls); do
        mv $i $i.py3
done
popd

%check
export VIRTUALENV_SYSTEM_SITE_PACKAGES=YES
export TOX_LIMITED_SHEBANG=1
export PIP_NO_BUILD_ISOLATION=NO
%pyproject_run_pytest -vra -m "not internet"

%files
%_bindir/tox.py3
%_bindir/tox-quickstart.py3
%python3_sitelibdir/tox/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
