%define oname tqdm

%def_with check

Name: python3-module-tqdm
Version: 4.66.5
Release: alt1.p10.1

Summary: A fast, extensible progress bar for Python and CLI

License: MIT and MPL-2.0
Group: Development/Python
Url: https://pypi.org/project/tqdm

Source: %name-%version.tar
Source1: setuptools-68.2.2-py3-none-any.whl

BuildArch: noarch

Conflicts: python-module-%oname
Obsoletes: python-module-%oname

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-asyncio
BuildRequires: python3-module-pytest-timeout
BuildRequires: python3-module-numpy
%endif

# make optional
%add_python3_req_skip dask.callbacks rich.progress

%description
tqdm means "progress" in Arabic (taqadum) and an abbreviation
for "I love you so much" in Spanish (te quiero demasiado).

Instantly make your loops show a smart progress meter -
just wrap any iterable with tqdm(iterable), and you're done!

%prep
%setup
sed -ie 's/timeout = 30/timeout = 60/' pyproject.toml

%build
# build with bundled setuptools
mkdir dist
cp %SOURCE1 dist/
echo "$(basename '%SOURCE1')" > dist/.wheeltracker
%pyproject_run -- bash -s <<-'ENDUNITTEST'
# redefine __python3 to python3 instead of /usr/bin/python3 to point to virt one
%global __python3_orig %__python3
%define __python3 python3
%pyproject_build
%define __python3 %__python3_orig
ENDUNITTEST

%install
%pyproject_install

%check
# https://github.com/tqdm/tqdm/issues/1537
%pyproject_run_pytest -o=addopts="-v --tb=short -rxs -W=error --durations=0 --durations-min=0.1"

%files
%doc *.rst
%_bindir/tqdm
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}

%changelog
