%define _unpackaged_files_terminate_build 1
%define oname veusz

Name: python3-module-%oname
Version: 3.3.1
Release: alt1

Summary: A Scientific Plotting Package
License: GPLv2+
Group: Development/Python3
Url: http://home.gna.org/veusz/

# Source0-git: https://github.com/veusz/veusz.git
Source0: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: /usr/bin/pod2man /usr/bin/man texlive-dist
BuildRequires: python3-devel libnumpy-py3-devel
BuildRequires: qt5-base-devel python3-module-PyQt5-devel
BuildRequires: python3-module-sip5

%add_python3_req_skip pyemf

%description
Veusz is a GUI scientific plotting and graphing package. It is designed
to produce publication-ready Postscript or PDF output. SVG, EMF and
bitmap export formats are also supported. The program runs under
Unix/Linux, Windows or Mac OS X, and binaries are provided. Data can be
read from text, CSV or FITS files, and data can be manipulated or
examined from within the application.

%package docs
Summary: Documentation for Veusz
Group: Development/Documentation
BuildArch: noarch

%description docs
Veusz is a GUI scientific plotting and graphing package. It is designed
to produce publication-ready Postscript or PDF output. SVG, EMF and
bitmap export formats are also supported. The program runs under
Unix/Linux, Windows or Mac OS X, and binaries are provided. Data can be
read from text, CSV or FITS files, and data can be manipulated or
examined from within the application.

This packagec contains documentation for Veusz.

%package examples
Summary: Examples for Veusz
Group: Development/Documentation
Requires: %name = %version-%release

%description examples
Veusz is a GUI scientific plotting and graphing package. It is designed
to produce publication-ready Postscript or PDF output. SVG, EMF and
bitmap export formats are also supported. The program runs under
Unix/Linux, Windows or Mac OS X, and binaries are provided. Data can be
read from text, CSV or FITS files, and data can be manipulated or
examined from within the application.

This package contains examples for Veusz.

%package -n %oname
Summary: A Scientific Plotting Package
Group: Graphics
Conflicts: %name < %version-%release
Requires: %name = %version-%release
Requires: %name-examples = %version-%release

%description -n %oname
Veusz is a GUI scientific plotting and graphing package. It is designed
to produce publication-ready Postscript or PDF output. SVG, EMF and
bitmap export formats are also supported. The program runs under
Unix/Linux, Windows or Mac OS X, and binaries are provided. Data can be
read from text, CSV or FITS files, and data can be manipulated or
examined from within the application.

This package contains main scripts for Veusz.

%prep
%setup

find ./ -type f -name '*.py' -exec \
	sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' '{}' +

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug

%install
%python3_install

%files
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/examples

%files examples
%python3_sitelibdir/*/examples

%files -n %oname
%doc AUTHORS ChangeLog COPYING README.md
%_bindir/*


%changelog
