%define _unpackaged_files_terminate_build 1
%define pypi_name Werkzeug
%define pypi_nname werkzeug
%define mod_name werkzeug

%def_with check

Name: python3-module-%pypi_nname
Version: 2.3.8
Release: alt1

Summary: Werkzeug is one of the most advanced WSGI utility modules
License: BSD-3-Clause
Group: Development/Python3
URL: https://palletsprojects.com/p/werkzeug/
VCS: https://github.com/pallets/werkzeug

BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch

# well-known PyPI name
Provides: python3-module-%pypi_name = %EVR

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_check
BuildRequires: /proc
%endif

%description
Werkzeug is a comprehensive WSGI web application library.
It began as a simple collection of various utilities for WSGI
applications and has become one of the most advanced WSGI utility libraries.

Flask wraps Werkzeug, using it to handle the details of WSGI while providing
more structure and patterns for defining powerful applications.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile requirements/tests.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
# skip: test_serving::test_reloader_sys_path (hangs up) and test_serving::test_exclude_patterns (always fails)
%pyproject_run_pytest -vra -k "not test_reloader_sys_path and not test_exclude_patterns"

%files
%doc LICENSE.rst CHANGES.rst README.rst
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
