%define oname zope.configuration

%def_without check

Name: python3-module-%oname
Version: 4.4.0
Release: alt2

Summary: Zope Configuration Markup Language (ZCML) (Python 3)
License: ZPL
Group: Development/Python3

Url: http://pypi.python.org/pypi/zope.configuration/
#Git: https://github.com/zopefoundation/zope.configuration.git

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx-devel
BuildRequires: python3-module-repoze.sphinx.autointerface
BuildRequires: python3-module-coverage
BuildRequires: python3-module-nosexcover
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-zope.i18nmessageid
BuildRequires: python3-module-zope.schema

%if_with check
BuildRequires: python3-module-tox
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-coverage
BuildRequires: python3-module-manuel-tests
BuildRequires: python3-module-manuel
%endif

%py3_requires zope.i18nmessageid
%py3_requires zope.interface zope.schema

%description
The zope configuration system provides an extensible system for
supporting various kinds of configurations.

It is based on the idea of configuration directives. Users of the
configuration system provide configuration directives in some language
that express configuration choices. The intent is that the language be
pluggable. An XML language is provided by default.

%package tests
Summary: Tests for Zope Configuration Markup Language (ZCML) (Python 3)
Group: Development/Python3
Requires: %name = %EVR
%py3_requires zope.testing
%add_python3_req_skip bad_to_the_bone

%description tests
The zope configuration system provides an extensible system for
supporting various kinds of configurations.

It is based on the idea of configuration directives. Users of the
configuration system provide configuration directives in some language
that express configuration choices. The intent is that the language be
pluggable. An XML language is provided by default.

This package contains tests for Zope Configuration Markup Language
(ZCML).

%package pickles
Summary: Pickles for Zope Configuration Markup Language (ZCML)
Group: Development/Python

%description pickles
The zope configuration system provides an extensible system for
supporting various kinds of configurations.

It is based on the idea of configuration directives. Users of the
configuration system provide configuration directives in some language
that express configuration choices. The intent is that the language be
pluggable. An XML language is provided by default.

This package contains pickles for Zope Configuration Markup Language
(ZCML).

%prep
%setup

%prepare_sphinx3 .
ln -s ../objects.inv3 docs/

%build
%python3_build

%install
%python3_install
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

export PYTHONPATH=$PWD/src
sed -i "s|SPHINXBUILD   = sphinx-build|SPHINXBUILD   = py3_sphinx-build|" docs/Makefile
%make -C docs pickle
%make -C docs html
install -d %buildroot%python3_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/

%check
sed -i 's|sphinx-build|py3_sphinx-build|g' tox.ini

tox.py3 --sitepackages -e py%{python_version_nodots python3} -v

%files
%doc *.txt *.rst docs/_build/html
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/pickle
%exclude %python3_sitelibdir/*/*/tests

%files pickles
%python3_sitelibdir/*/pickle

%files tests
%python3_sitelibdir/*/*/tests

%changelog
