%define oname zope.server

%def_with check

Name: python3-module-%oname
Version: 4.0.2
Release: alt1
Summary: Zope Server (Web and FTP)
License: ZPLv2.1
Group: Development/Python3
Url: http://pypi.python.org/pypi/zope.server/
#Git: https://github.com/zopefoundation/zope.server.git

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools

%if_with check
BuildRequires: python3-module-tox
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zope.publisher
BuildRequires: python3-module-paste
BuildRequires: python3-module-zope.component-tests
%endif

%py3_requires zope zope.interface zope.publisher zope.security

%description
This package contains generic base classes for channel-based servers,
the servers themselves and helper objects, such as tasks and requests.

%package tests
Summary: Tests for zope.server
Group: Development/Python3
Requires: %name = %EVR
%py3_requires zope.testing zope.i18n zope.component

%description tests
This package contains generic base classes for channel-based servers,
the servers themselves and helper objects, such as tasks and requests.

This package contains tests for zope.server.

%prep
%setup

%build
%python3_build

%install
%python3_install
%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
sed -i '/\[testenv\]$/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
setenv =\
    py%{python_version_nodots python3}: _PYTEST_BIN=%_bindir\/zope-testrunner3\
commands_pre =\
    \/bin\/cp {env:_PYTEST_BIN:} \{envbindir\}\/zope-testrunner3\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/zope-testrunner3' tox.ini

sed -i 's|zope-testrunner |zope-testrunner3 |g' tox.ini

tox.py3 --sitepackages -e py%{python_version_nodots python3} -v

%files
%doc *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests
%exclude %python3_sitelibdir/*/*/*/tests

%files tests
%python3_sitelibdir/*/*/tests
%python3_sitelibdir/*/*/*/tests

%changelog
