%define _unpackaged_files_terminate_build 1

%def_with ClangCodeModel
%define llvm_version 13.0
%define qt_version 5.15.2

%add_findreq_skiplist  %_datadir/qtcreator/*
%add_findprov_skiplist %_datadir/qtcreator/*

Name:    qt-creator
Version: 8.0.2
Release: alt1

Summary: Cross-platform IDE for Qt
License: GPL-3.0 with Qt-GPL-exception-1.0 and MIT and LGPL-2.0 and LGPL-2.1 and LGPL-3.0 and BSD-3-Clause and BSL-1.0 and ALT-Public-Domain
Group:   Development/Tools

URL: http://qt-project.org/wiki/Category:Tools::QtCreator
VCS: git://code.qt.io/qt-creator/qt-creator.git
Packager: Andrey Cherepanov <cas@altlinux.org>

ExcludeArch: %not_qt5_qtwebengine_arches

Source: %name-%version.tar
Source1: submodules.tar

Patch0: %name-%version-%release.patch

Provides: qtcreator = %EVR
Obsoletes: qtcreator-clangcodemodel
Provides: qtcreator-clangcodemodel = %EVR

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires(pre): qt5-base-devel >= %qt_version
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-qt5-webengine
BuildRequires: gcc-c++
BuildRequires: qt5-designer >= %qt_version
BuildRequires: qt5-script-devel >= %qt_version
BuildRequires: qt5-declarative-devel >= %qt_version
%ifnarch %e2k
# NB: there's rpm-macros-qt5-webengine out there
BuildRequires: qt5-webkit-devel >= %qt_version
%endif
BuildRequires: qt5-x11extras-devel >= %qt_version
BuildRequires: qt5-xmlpatterns-devel >= %qt_version
BuildRequires: qt5-tools-devel >= %qt_version
BuildRequires: qt5-serialport-devel
BuildRequires: qt5-webengine-devel >= %qt_version
BuildRequires: qt5-svg-devel >= %qt_version
BuildRequires: qt5-quickcontrols2-devel
BuildRequires: kf5-syntax-highlighting-devel
%if_with ClangCodeModel
BuildRequires: clang%llvm_version
BuildRequires: clang%llvm_version-devel
BuildRequires: clang%llvm_version-tools
BuildRequires: clangd%llvm_version
BuildRequires: lld%llvm_version
BuildRequires: llvm%llvm_version-devel
BuildRequires: llvm%llvm_version-tools
%endif
BuildRequires: libsystemd-devel
BuildRequires: elfutils-devel
BuildRequires: libzstd-devel
BuildRequires: zlib-devel
# Qbs documentation
#BuildRequires: python3-module-lxml
#BuildRequires: python3-module-bs4
# Missing build requirements
#BuildRequires: litehtml-devel

Requires: %name-core = %EVR
# Add Qt5 build environment to build Qt project
Requires: qt5-base-devel
Requires: qt5-tools

%ifarch %e2k
# error: cpio archive too big - 4446M
%global __find_debuginfo_files %nil
%endif

%description
Qt Creator (previously known as Project Greenhouse) is a new, lightweight,
cross-platform integrated  development environment (IDE) designed to make
development with the Qt application framework even faster and easier.

This package contains IDE and Qt5 build environment.

%package core
Summary: Cross-platform IDE for Qt
Group:   Development/Tools
Requires: %name-data = %EVR
Provides: qbs = 1.14.0
Obsoletes: qbs < 1.14.0
Requires: qt5-quickcontrols
Requires: qt5-translations

%description core
Qt Creator (previously known as Project Greenhouse) is a new, lightweight,
cross-platform integrated  development environment (IDE) designed to make
development with the Qt application framework even faster and easier.

This is core part of IDE without Qt5 build environment.

%package doc
Summary: %name docs
Group: Documentation
%ifnarch %not_qt5_qtwebengine_arches
Requires: %name
%endif
Requires: qt5-base-doc
Requires: qt5-tools

%description doc
Documentation for %name

%package data
Summary: Data files for %name
Group: Development/Tools
%ifnarch %not_qt5_qtwebengine_arches
Requires: %name-core = %EVR
%endif

%description data
Data files for %name

%prep
%setup
# Unpack submodules content
tar xf %SOURCE1
#sed -i 's,tools\/qdoc3,bin,' doc/doc.pri
#subst 's,share\/doc\/qtcreator,share\/qtcreator\/doc,' doc/doc.pri src/plugins/help/helpplugin.cpp
%patch0 -p1
%ifarch %e2k
# strip UTF-8 BOM, lcc 1.23 won't ignore it yet
find src -type f -print0 -name '*.cpp' -o -name '*.h' |
	xargs -r0 sed -ri 's,^\xEF\xBB\xBF,,'
%endif
# Use Python3 for Python scripts
subst 's@#!.*python[23]\?@#!%__python3@' `find . -name \*.py` \
	src/shared/qbs/src/3rdparty/python/bin/dmgbuild \
	src/libs/qt-breakpad/qtbreakpadsymbols

%build
%global optflags_lto %optflags_lto -ffat-lto-objects
export QTDIR=%_qt5_prefix
export PATH="%{_qt5_bindir}:$PATH"
export ALTWRAP_LLVM_VERSION="%llvm_version"
%ifarch %e2k
# fool sqlite into building with lcc
sed -i 's,^QMAKE_CFLAGS_WARN_ON.*$,& -D__INTEL_COMPILER,' src/libs/3rdparty/sqlite/sqlite.pri
%endif
%if_with ClangCodeModel
export LLVM_INSTALL_DIR="%_prefix"
%remove_optflags -frecord-gcc-switches
%endif

%cmake -GNinja \
    -Wno-dev \
    -DWITH_DOCS=ON \
    -Djournald=ON \
    -DBUILD_DEVELOPER_DOCS=OFF \
    -DCMAKE_INSTALL_LIBDIR=%_lib \
    -DCMAKE_EXE_LINKER_FLAGS="$LDFLAGS -Wl,-rpath,%_libdir/qtcreator -Wl,-rpath,%_libdir/qtcreator/plugins" \
    -DCMAKE_SHARED_LINKER_FLAGS="$LDFLAGS -Wl,-rpath,%_libdir/qtcreator -Wl,-rpath,%_libdir/qtcreator/plugins"

%ninja_build -C "%_cmake__builddir"
%ninja_build -C "%_cmake__builddir" qch_docs

%install
%ninja_install -C "%_cmake__builddir"
# Unable to install documentstion using ninja-build
#%%ninja_install -C "%_cmake__builddir" qch_docs
install -Dpm0644 %_cmake__builddir/share/doc/qtcreator/qtcreator.qch %buildroot%_defaultdocdir/qtcreator/qtcreator.qch

# Remove Windows cdb debugger support to prevent unmet python2.7(cdbext)
rm -f %buildroot%_datadir/qtcreator/debugger/cdbbridge.py

%files

%files core
%doc README* LICENSE*
%_bindir/*
%_libdir/qtcreator
%_prefix/libexec/qtcreator
%_iconsdir/hicolor/*/apps/QtProject-qtcreator.png
%_desktopdir/*.desktop
%_datadir/metainfo/*.xml

%files doc
%_defaultdocdir/qtcreator

%files data
%dir %_datadir/qtcreator
%_datadir/qtcreator/*

%changelog
