Name:		qtsmbstatus
Version:	2.2.1
Release:	alt2
License:	GPLv2
Group:		Networking/Other
Source:	    %name-%version.tar.gz
Summary:	QtSmbstatus is a GUI for smbstatus
Url:		http://qtsmbstatus.free.fr/
Packager:	Motsyo Gennadi <drool@altlinux.ru>
Patch:      %name-2.2.1-alt-changes.patch
Patch1:     %name-2.1-alt-fix-gcc4.4.patch

BuildRequires: gcc-c++ /usr/bin/convert libpam-devel libqt4-devel

Requires: %name-common = %version-%release

%description
QtSmbstatus is a GUI (graphical user interface) for smbstatus.
It is meant to provide the possibility of administering remote
machines.

QtSmbstatus was designed as a client/server system secured with
SSL. A login and password is required to log on to server (PAM).
The server's application ought to be installed with samba-server.

%package -n %name-common
Summary: QtSmbstatus common files
Group: Networking/Other

%description -n %name-common
Common files for QtSmbstatus.

Include docs and translations.

%package -n %name-server
Summary: QtSmbstatus server
Group: System/Servers
Requires: samba

Requires: %name-common = %version-%release

%description -n %name-server
Server for QtSmbstatus

%package -n %name-light
Summary: QtSmbstatus for local use only
Group: System/Servers
Requires: samba

Requires: %name-common = %version-%release

%description -n %name-light
To use QtSmbstatus only locally (without qtsmbstatus client/server), just
install qtsmbstatus-light.

%prep
%setup -q
%patch -p1
%patch1 -p1

%build
export PATH=$PATH:%_qt4dir/bin
lrelease client/tr/*.ts
qmake "QMAKE_CFLAGS+=%optflags" "QMAKE_CXXFLAGS+=%optflags" %name.pro
%make_build

%install
%make INSTALL_ROOT=%buildroot install
%__mkdir -p %buildroot/{%_miconsdir,%_niconsdir,%_liconsdir}
convert -resize 16x16 client/icons/samba.png %buildroot%_miconsdir/%name.png
convert -resize 32x32 client/icons/samba.png %buildroot%_niconsdir/%name.png
convert -resize 48x48 client/icons/samba.png %buildroot%_liconsdir/%name.png

convert -resize 16x16 client/icons/qtsmbstatusl.png %buildroot%_miconsdir/qtsmbstatusl.png
convert -resize 32x32 client/icons/qtsmbstatusl.png %buildroot%_niconsdir/qtsmbstatusl.png

%find_lang %name

%post -n %name-server
%post_service %{name}d

%files
%_bindir/%name
%_man7dir/%name.*
%_desktopdir/%name.desktop
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_pixmapsdir/%name.xpm

%files -f %name.lang -n %name-common
%_datadir/%name
%doc README* changelog INSTALL COPYING

%files -n %name-server
%_sbindir/%{name}d
%_initdir/%{name}d
%_man7dir/%{name}d.*
%attr(750,root,root) %_sysconfdir/%{name}d
%_sysconfdir/pam.d/%{name}d

%files -n %name-light
%_bindir/%{name}l
%_desktopdir/%{name}l.desktop
%_man7dir/%{name}l.*
%_miconsdir/%{name}l.png
%_niconsdir/%{name}l.png
%_pixmapsdir/%{name}l.xpm

%changelog
