%def_disable snapshot
%define gst_api_ver 1.0
%define rdn_name io.github.quodlibet.QuodLibet
%define rdn_name_ef io.github.quodlibet.ExFalso

Name: quodlibet
Version: 4.4.0
Release: alt1

Summary: audio library tagger, manager, and player for GTK+
Group: Sound
License: GPLv2
Url: https://github.com/%name/%name

%if_disabled snapshot
Source: %url/releases/download/release-%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

BuildArch: noarch

Requires(pre): exfalso = %version-%release
Requires: python3 >= 3.7
# explicitly required gtk+3
Requires: typelib(Gtk) = 3.0
Requires: dbus dconf
Requires: python3-module-musicbrainzngs >= 0.6

# required GStreamer plugins
Requires: gst-plugins-base%gst_api_ver
Requires: gst-plugins-good%gst_api_ver
Requires: gst-plugins-bad%gst_api_ver
Requires: gst-plugins-ugly%gst_api_ver

# remove ubuntu and Mac-specific dependencies
%add_typelib_req_skiplist typelib(Unity) typelib(AppIndicator3) typelib(Dbusmenu)
%add_typelib_req_skiplist typelib(GtkosxApplication)

# abnormally detected python3 dep. See quodlibet/util/http.py
%add_python3_req_skip gi.repository.GObject

BuildRequires(pre): rpm-build-gir rpm-build-python3
BuildRequires: desktop-file-utils
BuildRequires: python3-devel python3-module-mutagen

%description
Quod Libet is a music management program. It provides several different
ways to view your audio library, as well as support for Internet radio
and audio feeds. It has extremely flexible metadata tag editing and
searching capabilities.

%package -n exfalso
Summary: audio tag editor for GTK+
Group: Sound

%description -n exfalso
exfalso lets you display and edit any tags you want in the file. And it
lets you do this for all the file formats it supports -- Ogg Vorbis,
FLAC, MP3, Musepack, and MOD.

%prep
%setup

# fix appdata install path
subst "s|\('share', '\)appdata'|\1metainfo'|" gdist/appdata.py

%build
%python3_build

%install
%python3_install

%find_lang %name

%files
%_bindir/%name
# cli tagger
%_bindir/operon
%_datadir/dbus-1/services/net.sacredchao.QuodLibet.service
%_datadir/gnome-shell/search-providers/%rdn_name-search-provider.ini
%_iconsdir/hicolor/*/*/%{rdn_name}*.*
%_desktopdir/%rdn_name.desktop
%_datadir/metainfo/%rdn_name.appdata.xml
%_datadir/bash-completion/completions/%name
%_datadir/bash-completion/completions/operon
%_datadir/zsh/site-functions/_quodlibet
%_man1dir/%name.*
%_man1dir/operon.*
%doc NEWS* README*

%files -n exfalso -f %name.lang
%_bindir/exfalso
%_iconsdir/hicolor/*/*/%{rdn_name_ef}*.*
%_desktopdir/%rdn_name_ef.desktop
%_datadir/metainfo/%rdn_name_ef.appdata.xml
%_man1dir/exfalso.*
%python3_sitelibdir_noarch/%name
%python3_sitelibdir_noarch/%name-%version-py*

%changelog
