%def_enable snapshot
%define ver_major 2.1

Name: rawstudio
Version: %ver_major
Release: alt0.6

Summary: Rawstudio is an open source raw-image converter written in GTK+
License: GPLv2+
Group: Graphics
Url: http://rawstudio.org/

%if_disabled snapshot
Source: http://rawstudio.org/files/release/rawstudio-%version.tar.gz
%else
#Vcs: https://github.com/rawstudio/rawstudio.git
Vcs: https://github.com/sergiomb2/rawstudio.git
Source: %name-%version.tar
%endif

Patch1: rawstudio-2.0-fc-lensfun.patch
Patch2: rawstudio-2.1-alt-lfs.patch

BuildRequires: gcc-c++ libgtk+3-devel libappstream-glib-devel libGConf-devel libdbus-devel
BuildRequires: libexiv2-devel liblcms2-devel libfftw3-devel libflickcurl-devel
BuildRequires: libgphoto2-devel libjpeg-devel liblcms-devel liblensfun-devel libpng-devel
BuildRequires: libsqlite3-devel libssl-devel libtiff-devel libosm-gps-map-devel
BuildRequires: libxml2-devel libpugixml-devel

%description
Rawstudio can read and convert RAW-images from most digital cameras.

%prep
%setup
%patch1 -p1
%patch2

[ ! -d m4 ] && mkdir m4

%build
%add_optflags -DGLIB_VERSION_MIN_REQUIRED=GLIB_VERSION_2_32
glib-gettextize -c -f
%autoreconf
%configure --disable-static \
    --enable-experimental \
    --enable-maintainer-mode
%nil
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%_bindir/%name
%_libdir/%name/
%_datadir/%name/
%_libdir/lib%name-%ver_major.so
%_libdir/lib%name.so
%_datadir/rawspeed/
%_pixmapsdir/*
%_iconsdir/%name.png
#%_liconsdir/*
%_desktopdir/%name.desktop
%_datadir/appdata/%name.appdata.xml

%exclude %_includedir/%name-%ver_major/
#%exclude %_libdir/*.so
%exclude %_pkgconfigdir

%changelog
