%global _unpackaged_files_terminate_build 1
%define redis_user      _redis
%define redis_group     _redis

%ifarch %arm %mips32
%def_disable check
%else
%def_enable check
%endif

Name: redis
Version: 6.2.17
Release: alt1

Summary: Redis is an advanced key-value store

Group: Databases
# redis, hiredis: BSD-3-Clause
# hdrhistogram, jemalloc, lzf, linenoise: BSD-2-Clause
# lua: MIT
# fpconv: BSL-1.0
License: BSD-3-Clause AND BSD-2-Clause AND MIT AND BSL-1.0
URL: http://redis.io/
Vcs: https://github.com/redis/redis.git

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source0: %name-%version.tar
Patch0:  %name-%version-%release.patch

Source2: redis-benchmark.1
Source3: redis-cli.1
Source4: redis-server.1
Source5: redis-cli.bash_completion
Source6: redis-server.logrotate
Source7: redis.init
Source8: redis.sysconfig
Source9: redis.service
Source10: redis-sentinel.service

Patch1: %name-6.2.3-alt-mips32.patch

BuildRequires: gcc-c++ libssl-devel libsystemd-devel

# for check section
BuildRequires: tcl >= 8.5  tcl-tls openssl
BuildRequires: /proc

Provides: %name-server = %EVR
Provides: %name-sentinel = %EVR
Requires: %name-cli = %EVR

%description
Redis is an advanced key-value store. It is similar to memcached but
the dataset is not volatile, and values can be strings, exactly like in
memcached, but also lists, sets, and ordered sets. All this data types can
be manipulated with atomic operations to push/pop elements, add/remove
elements, perform server side union, intersection, difference between
sets, and so forth. Redis supports different kind of sorting abilities.

In order to be very fast but at the same time persistent the whole dataset
is taken in memory, and from time to time saved on disc asynchronously
(semi persistent mode) or alternatively every change is written into an
append only file (fully persistent mode). Redis is able to rebuild the
append only file in background when it gets too big.

Redis supports trivial to setup master-slave replication, with very
fast non-blocking first synchronization, auto reconnection on net split,
and so forth.

Redis is written in ANSI C and works in most POSIX systems like Linux,
*BSD, Mac OS X, Solaris, and so on. Redis is free software released under
the very liberal BSD license. Redis is reported to compile and work
under WIN32 if compiled with Cygwin, but there is no official support
for Windows currently.

%package cli
Summary: Development header for Redis module development
Group: Networking/Other
Provides: %name-tools = %EVR

%description cli
Header file required for building loadable Redis modules.

%package devel
Summary: Development header for Redis module development
Group: Development/C

%description       devel
Header file required for building loadable Redis modules.

%prep
%setup
%patch0 -p1

%build

# For e2k - force use libc malloc instead jemalloc (see #35473)
USE_MALLOC=
%ifarch %e2k
USE_MALLOC="USE_JEMALLOC=no MALLOC=libc"
%else
USE_MALLOC="USE_JEMALLOC=yes"
%endif

%global make_flags CXXFLAGS="%optflags" CFLAGS="%optflags" OPTIMIZATION="" DEBUG_FLAGS="" DEBUG="" V="echo" PREFIX=%buildroot%_prefix $USE_MALLOC BUILD_TLS=yes USE_SYSTEMD=yes
%make_build %make_flags all

%check
./utils/gen-test-certs.sh
./runtest --clients 1 --verbose --tags -largemem:skip --skipunit unit/oom-score-adj --skipunit unit/memefficiency  --skiptest "CONFIG SET rollback on apply error" --tls
./runtest-moduleapi
timeout 120m ./runtest-cluster --tls
./runtest-sentinel

%install
%make_install %make_flags install
mkdir -p %buildroot%_sbindir
mkdir -p %buildroot%_sysconfdir/%name
mv %buildroot%_bindir/redis-server %buildroot%_sbindir/
mv %buildroot%_bindir/redis-sentinel %buildroot%_sbindir/
ln -nsf ../sbin/redis-server %buildroot%_bindir/redis-check-aof
ln -nsf ../sbin/redis-server %buildroot%_bindir/redis-check-rdb

mkdir -p %buildroot%_sharedstatedir/%name
mkdir -p %buildroot%_logdir/%name

mkdir -p %buildroot%_man1dir
install -m 644 %SOURCE2 %buildroot%_man1dir/
install -m 644 %SOURCE3 %buildroot%_man1dir/
install -m 644 %SOURCE4 %buildroot%_man1dir/

# Tune default configuration
sed -e '/^timeout[[:blank:]]/ s/0/300/' \
    -e '/^daemonize[[:blank:]]/ s/no/yes/' \
    -e '/^pidfile[[:blank:]]/ s^/var/run/redis_6379.pid^/run/redis/redis-server.pid^' \
    -e '/^logfile[[:blank:]]/ s^""^"/var/log/redis/redis-server.log"^' \
    -e '/^dir[[:blank:]]/ s^\./^/var/lib/redis^' \
    -i %name.conf

sed -e '/^daemonize[[:blank:]]/ s/no/yes/' \
    -e '/^pidfile[[:blank:]]/ s^/var/run/redis-sentinel.pid^/run/redis/redis-sentinel.pid^' \
    -e '/^logfile[[:blank:]]/ s^""^"/var/log/redis/redis-sentinel.log"^' \
    -e '/^dir[[:blank:]]/ s^/tmp^/var/lib/redis^' \
    -i sentinel.conf

install -m644 %name.conf %buildroot%_sysconfdir/%name/
install -m644 sentinel.conf %buildroot%_sysconfdir/%name/

mkdir -p %buildroot%_datadir/bash-completion/completions
install -m 644 %SOURCE5 %buildroot%_datadir/bash-completion/completions/redis-cli

mkdir -p %buildroot%_logrotatedir
install -m 640 %SOURCE6 %buildroot%_logrotatedir/redis-server

mkdir -p  %buildroot%_initdir
install -m 0755 %SOURCE7 %buildroot%_initdir/%name

mkdir -p %buildroot%_sysconfdir/sysconfig
install -m 0640 %SOURCE8 %buildroot%_sysconfdir/sysconfig/%name

mkdir -p  %buildroot%_unitdir
install -m 0644 %SOURCE9  %buildroot%_unitdir/%name.service
install -m 0644 %SOURCE10 %buildroot%_unitdir/%name-sentinel.service

mkdir -p  %buildroot%_tmpfilesdir
echo 'd /run/%name 0755 %redis_user %redis_group' >> %buildroot%_tmpfilesdir/%name.conf

# Install redis module header
install -pDm644 src/%{name}module.h %buildroot%_includedir/%{name}module.h

%pre
# Add the "_redis" user
groupadd -r -f %redis_group 2>/dev/null ||:
useradd  -r -g %redis_group -c 'Redis daemon' \
        -s /dev/null -M -d %_sharedstatedir/%name %redis_user 2>/dev/null ||:

%post
%post_service %name
%post_service %name-sentinel

%preun
%preun_service %name
%preun_service %name-sentinel

%files
%doc COPYING 00-RELEASENOTES README.md BUGS MANIFESTO

%attr(0770,root,%redis_group) %dir %_sysconfdir/%name
%config(noreplace) %attr(0640, %redis_user, %redis_group) %_sysconfdir/%name/redis.conf
%config(noreplace) %attr(0640, %redis_user, %redis_group) %_sysconfdir/%name/sentinel.conf
%config(noreplace) %_logrotatedir/redis-server
%attr(0640,root,%redis_group) %config(noreplace) %_sysconfdir/sysconfig/%name
%config %_initdir/%name
%_unitdir/*.service
%_tmpfilesdir/%name.conf

%_bindir/%name-check-aof
%_bindir/%name-check-rdb
%_sbindir/%name-server
%_sbindir/%name-sentinel
%_man1dir/%name-server.*
%dir %attr(0750,%redis_user,%redis_group) %_logdir/%name
%dir %attr(0750,%redis_user,%redis_group) %_sharedstatedir/%name

%files cli
%_bindir/%name-cli
%_bindir/%name-benchmark
%_datadir/bash-completion/completions/%name-cli
%_man1dir/%name-benchmark.*
%_man1dir/%name-cli.*

%files devel
%_includedir/%{name}module.h

%changelog
