%define soname 2
%define bdir lib/comgr

%define optflags_lto %nil

Name: rocm-comgr
Version: 5.7.0
Release: alt0.p10.2
License: NCSA
Summary: AMD Code Object Manager (Comgr)
Url: https://github.com/RadeonOpenCompute/ROCm-CompilerSupport
Group: Development/C++

Source: %name-%version.tar

# link llvm statically due collisions with Mesa
Patch0: %name-llvm-static.patch
# device libs path
Patch1: rocm-alt-device-libs-path.patch
# use llvm-rocm commands
Patch2: rocm-comgr-use-llvm-rocm.patch

BuildRequires(pre): cmake
BuildRequires: llvm-rocm-devel = %version clang-rocm-devel = %version clang-rocm-tools = %version lld-rocm-devel = %version
BuildRequires: zlib-devel libstdc++-devel rocm-cmake = %version rocm-device-libs = %version ncurses-devel

# clang segfaults on armh
# doesn't compile on ix86
# and llvm-rocm exists only for x86_64
ExclusiveArch: x86_64

%description
The Comgr library provides APIs for compiling and inspecting AMDGPU code
objects.

%package -n libamd_comgr%{soname}
Summary: AMD Code Object Manager (Comgr) library
Group: System/Libraries
Provides: libamd_comgr = %EVR
Requires: clang-rocm-libs-support = %version, lld-rocm = %version

%description -n libamd_comgr%{soname}
The Comgr library provides APIs for compiling and inspecting AMDGPU code
objects.

%package devel
Summary: AMD Code Object Manager (Comgr) headers
Group: Development/C++

%description devel
AMD Code Object Manager (Comgr) develpment library and headers

%prep
%setup
%autopatch -p1

%build
pushd %{bdir}
export ALTWRAP_LLVM_VERSION=rocm
%cmake \
    -DCMAKE_C_COMPILER=clang \
    -DCMAKE_CXX_COMPILER=clang++ \
    -DLLD_DIR=%_prefix/lib/llvm-rocm/%_lib/cmake/lld \
    -DCMAKE_CXX_LINKER_FLAGS='-fuse-ld=lld' \
    -DCMAKE_SHARED_LINKER_FLAGS='-fuse-ld=lld' \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo
%cmake_build

%install
pushd %{bdir}
%cmake_install

%files -n libamd_comgr%{soname}
%doc %{bdir}/README.md %{bdir}/LICENSE.txt %{bdir}/NOTICES.txt
%_libdir/libamd_comgr.so.%{soname}*

%files devel
%_includedir/*
%_libdir/libamd_comgr.so
%_libdir/cmake/amd_comgr

%changelog
