%define _unpackaged_files_terminate_build 1

Name: rrd
Version: 1.8.0
Release: alt3
%define native rrdtool
%define abiversion 8
%define rrdcached_user root
%def_with tcl

# fixed rrdcached.pid place
# https://lists.altlinux.org/pipermail/devel/2017-October/203277.html
%define _localstatedir /var

Summary: RRD - round robin database
License: GPL-2.0+ AND LGPL-2.0+
Group: Development/Databases

Url: http://oss.oetiker.ch/rrdtool

Source0: http://oss.oetiker.ch/rrdtool/pub/%native-%version.tar
Source1: rrdcached.init
Source2: rrdcached.sysconfig
Source3: rrdcached.service
Source10: MRTG-HOWTO

Patch0: rrd-1.7.2-alt-build-tcl.patch
Patch1: rrdtool-1.4.5-automake-1.11.2.patch
Patch2: rrdtool-1.4.7-alt-DSO.patch
Patch3: rrdtool-1.5.3-top-dir.patch

Requires: lib%name = %version-%release

BuildRequires(pre): rpm-build-python3
BuildRequires: chrpath
BuildRequires: python3-module-setuptools
%if_with tcl
BuildRequires(pre): rpm-build-tcl
BuildRequires: tcl-devel
%endif

# Automatically added by buildreq on Wed Oct 12 2011
BuildRequires: groff-base libdbi-devel libpango-devel libpng-devel libxml2-devel lua5 perl-Pod-Parser perl-devel python3-devel /usr/bin/pod2html
BuildRequires: libfreetype-devel zlib-devel fonts-ttf-dejavu

Summary(ru_RU.UTF-8): RRDtool - база данных с "циклическим обновлением"

%package -n lib%name%abiversion
Summary: Round Robin Database shared library
Group: System/Libraries
Requires: fonts-ttf-dejavu
Provides: lib%name = %version-%release

%package -n lib%name-devel
Summary: Round Robin Database development files and documentation
Group: Development/C
Requires: lib%name = %version-%release
Provides: %native-devel = %version
Obsoletes: %native-devel < %version

%package utils
Summary: Round Robin Database utilities
Group: Development/Databases
Requires: lib%name = %version-%release
Provides: %native = %version
Obsoletes: %native < %version

%package cached
Summary: Data caching daemon for RRDtool
Group: Databases
Requires: lib%name = %version-%release

%package man
Summary: Round Robin Database man pages
Group: Development/Documentation
BuildArch: noarch

%package doc
Summary: Round Robin Database documentation/examples
Group: Development/Documentation
BuildArch: noarch

%package -n perl-RRD
Summary: Round Robin Database perl modules
Group: Development/Databases
Requires: lib%name = %version-%release
Provides: %name-perl = %version
Obsoletes: %name-perl < %version

%package -n python3-module-rrdtool
Summary: Round Robin Database python modules
Group: Development/Databases
Requires: lib%name = %version-%release
Provides: python3-module-rrd = %version
Obsoletes: python3-module-rrd < 1.5.4-alt2

%if_with tcl
%package tcl
Summary: Round Robin Database tcl extension
Group: Development/Databases
Requires: lib%name = %version-%release
%endif

%description
RRD is the Acronym for Round Robin Database. RRD is a system to store and
display time-series data (i.e. network bandwidth, machine-room temperature,
server load average). It stores the data in a very compact way that will not
expand over time, and it presents useful graphs by processing the data to
enforce a certain data density. It can be used either via simple wrapper
scripts (from shell or Perl) or via frontends that poll network devices and
put a friendly user interface on it.

%description -l ru_RU.UTF-8
RRD - сокращение для "Round Robin Database" (база данных с "циклическим
обновлением"). RRD - система для сохранения и показа информации за
определённый промежуток времени (например скорость передачи данных в
сети, температуру в машинном зале, среднюю загрузку сервера). Она
сохраняет данные в очень компактной форме, так что данные не будут
занимать всё больше и больше места с течением времени и предоставляет
разумное графическое представление информации. Может быть использована
как из простых скриптов (shell, perl, etc), так встроена в программы,
которые опрашивают сетевые устройства и показывают данные в удобном
для пользователя виде.

%description -n lib%name%abiversion
RRD is the Acronym for Round Robin Database. RRD is a system to store and
display time-series data (i.e. network bandwidth, machine-room temperature,
server load average).

This package contains shared library required for running RRD-based software.

%description -n lib%name-devel
RRD is the Acronym for Round Robin Database. RRD is a system to store and
display time-series data (i.e. network bandwidth, machine-room temperature,
server load average).

This package contains development files and documentation required for
development of RRD-based software.

%description utils
RRD is the Acronym for Round Robin Database. RRD is a system to store and
display time-series data (i.e. network bandwidth, machine-room temperature,
server load average). It stores the data in a very compact way that will not
expand over time, and it presents useful graphs by processing the data to
enforce a certain data density. It can be used either via simple wrapper
scripts (from shell or Perl) or via frontends that poll network devices and
put a friendly user interface on it.

This package contains utilities for manipulating Round Robin Databases.

%description cached
rrdcached is a daemon that receives updates to existing RRD files,
accumulates them and, if enough have been received or a defined time has
passed, writes the updates to the RRD file.  The daemon was written with
big setups in mind which usually runs into I/O related problems.  This
daemon was written to alleviate these problems.

%description man
RRD is the Acronym for Round Robin Database. RRD is a system to store and
display time-series data (i.e. network bandwidth, machine-room temperature,
server load average). It stores the data in a very compact way that will not
expand over time, and it presents useful graphs by processing the data to
enforce a certain data density. It can be used either via simple wrapper
scripts (from shell or Perl) or via frontends that poll network devices and
put a friendly user interface on it.

This package contains man pages for Round Robin Databases.

%description doc
RRD is the Acronym for Round Robin Database. RRD is a system to store and
display time-series data (i.e. network bandwidth, machine-room temperature,
server load average). It stores the data in a very compact way that will not
expand over time, and it presents useful graphs by processing the data to
enforce a certain data density. It can be used either via simple wrapper
scripts (from shell or Perl) or via frontends that poll network devices and
put a friendly user interface on it.

This package contains documentations for manipulating Round Robin Databases.
Some examples included too.

%description -n perl-RRD
RRD is the Acronym for Round Robin Database. RRD is a system to store and
display time-series data (i.e. network bandwidth, machine-room temperature,
server load average). It stores the data in a very compact way that will not
expand over time, and it presents useful graphs by processing the data to
enforce a certain data density. It can be used either via simple wrapper
scripts (from shell or Perl) or via frontends that poll network devices and
put a friendly user interface on it.

This package contains perl modules for access the Round Robin Databases.

%description -n python3-module-rrdtool
RRD is the Acronym for Round Robin Database. RRD is a system to store and
display time-series data (i.e. network bandwidth, machine-room temperature,
server load average). It stores the data in a very compact way that will not
expand over time, and it presents useful graphs by processing the data to
enforce a certain data density. It can be used either via simple wrapper
scripts (from shell or Perl) or via frontends that poll network devices and
put a friendly user interface on it.

This package contains python modules for access the Round Robin Databases.

%if_with tcl
%description tcl
RRD is the Acronym for Round Robin Database. RRD is a system to store and
display time-series data (i.e. network bandwidth, machine-room temperature,
server load average). It stores the data in a very compact way that will not
expand over time, and it presents useful graphs by processing the data to
enforce a certain data density. It can be used either via simple wrapper
scripts (from shell or Perl) or via frontends that poll network devices and
put a friendly user interface on it.

This package contains tcl extension for access the Round Robin Databases.
%endif

%prep
%setup -n %native-%version
%patch0 -p2

find doc bindings/perl-piped -type f -print0 |
	xargs -r0 fgrep -l /usr/local |
	xargs -r perl -pi -e 's,/usr/local,%prefix,g'

# temporary hack for build tcl subpackage in Sisyphus
# https://lists.altlinux.org/pipermail/devel/2017-October/203186.html
sed -i 's@$TCL_PACKAGE_PATH@%_tcldatadir@g' configure.ac

%build
export PYTHON=%__python3
%add_optflags -I%_builddir/%native-%version/src %optflags_shared -I%_includedir/cgilib -lpng
%autoreconf
%configure \
	--disable-rpath \
	--enable-shared \
	--with-pic \
	--disable-static \
%if_with tcl
	--with-tcllib=%_libdir \
%endif
	--disable-ruby \
	--disable-lua

%make_build

make -C bindings clean

export LD_LIBRARY_PATH=$PWD/src/.libs
pushd bindings/perl-piped
	%perl_vendor_build
popd

pushd bindings/perl-shared
	%perl_vendor_build
popd

%install
pushd bindings/perl-piped
	%perl_vendor_install
popd

pushd bindings/perl-shared
	%perl_vendor_install
popd
pushd bindings
%make python
popd

%if_with tcl
mkdir -p %buildroot%_tcllibdir/
%endif
make DESTDIR=%buildroot install

# seems to have changed in newer configure,
# didn't find it in 5 min; fix here // mike
mv %buildroot%_datadir/%native/examples %buildroot%_docdir/%native-%version/
# ...and %buildroot%_datadir/%native isn't needed more ;-) //asy
rmdir %buildroot%_datadir/%native

# RPATH
find %buildroot -name '*.so' | xargs -n 1 chrpath -d

cp CONTRIBUTORS COPYRIGHT TODO NEWS THREADS LICENSE  %buildroot%_docdir/%native-%version/

#
# rrdcached
#
mkdir -p %buildroot{%_initdir,%_unitdir,%_sysconfdir/sysconfig}
mkdir -p %buildroot%_localstatedir/lib/rrdcached/{db,journal}
install -m755 %SOURCE1 %buildroot%_initdir/rrdcached
install -m644 %SOURCE3 %buildroot%_unitdir/rrdcached.service

sed -e 's|@@USER@@|%rrdcached_user|g' < %SOURCE2 > %buildroot%_sysconfdir/sysconfig/rrdcached

%find_lang %native

# warning: Installed (but unpackaged) file(s) found:
#    /usr/lib/perl/5.16.3/RRDp.pm
#    /usr/lib/perl/5.16.3/x86_64-linux-thread-multi/RRDs.pm
#    /usr/lib/perl/5.16.3/x86_64-linux-thread-multi/auto/RRDp/.packlist
#    /usr/lib/perl/5.16.3/x86_64-linux-thread-multi/auto/RRDs/.packlist
#    /usr/lib/perl/5.16.3/x86_64-linux-thread-multi/auto/RRDs/RRDs.bs
#    /usr/lib/perl/5.16.3/x86_64-linux-thread-multi/auto/RRDs/RRDs.so
#    /usr/lib/perl/5.16.3/x86_64-linux-thread-multi/perllocal.pod
rm -rf %buildroot/usr/lib/perl

#warning: Installed (but unpackaged) file(s) found:
#    /usr/share/tcl/tclrrd1.7.2/ifOctets.tcl
#    /usr/share/tcl/tclrrd1.7.2/pkgIndex.tcl
rm -rf %buildroot/usr/share/tcl

%pre cached
# %%rrdcached_user is root now, so groupadd/useradd is not needed
#/usr/sbin/groupadd -rf %rrdcached_user
#/usr/sbin/useradd -r -g %rrdcached_user -d /dev/null -s /dev/null -c "rrdcached daemon" %rrdcached_user &>/dev/null ||:

%post cached
%post_service rrdcached

%preun cached
%preun_service rrdcached

%files -n lib%name%abiversion
%doc COPYRIGHT
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*.h
%_libdir/lib*.so
%_libdir/pkgconfig/*

%files utils -f %native.lang
%doc COPYRIGHT
%exclude %_bindir/rrdcached
%_bindir/*

%files cached
%_bindir/rrdcached
%_initdir/rrdcached
%_unitdir/rrdcached.*
%config(noreplace) %_sysconfdir/sysconfig/rrdcached
%attr(3775,root,%rrdcached_user) %dir %_localstatedir/lib/rrdcached
%attr(3775,root,%rrdcached_user) %dir %_localstatedir/lib/rrdcached/db
%attr(3775,root,%rrdcached_user) %dir %_localstatedir/lib/rrdcached/journal

%files man
%_man1dir/*
%_man3dir/lib*

%files doc
%dir %_docdir/%native-%version
%doc %_docdir/%native-%version/*

%files -n perl-RRD
%perl_vendor_privlib/RRD*
%perl_vendor_archlib/RRD*
%perl_vendor_autolib/RRD*

%files -n python3-module-rrdtool
%python3_sitelibdir/*

%if_with tcl
%files tcl
%_libdir/tcl*.so
%endif

# TODO:
# - make proper switches for language bindings
#   (the tcl one looks broken too as of 1.5.4-alt2.1)

%changelog
