%define module_name scapy

Name: scapy
Version: 2.4.5
Release: alt1

Summary: Scapy is a powerful interactive packet manipulation program written in Python

Group: Networking/Other
License: GPLv2
Url: http://www.secdev.org/projects/scapy/

# Source-url: https://github.com/secdev/scapy/archive/v%version.zip
Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: %name-%version.tar

BuildArch: noarch

Requires: python3-module-scapy = %EVR

Requires: tcpdump

BuildRequires: python3-devel python3-module-setuptools
BuildRequires(pre): rpm-build-python3

%add_python3_req_skip scapy.modules.six.moves scapy.modules.six.moves.queue

# contrib
%add_python3_req_skip can.interface

%description
Scapy is a powerful interactive packet manipulation program.
It is able to forge or decode packets of a wide number of protocols,
send them on the wire, capture them, match requests and replies, and
much more.
It can easily handle most classical tasks like scanning, tracerouting,
probing, unit tests, attacks or network discovery.

%package -n python3-module-%name
Summary: Python module for %name.
Group: Development/Python

%description -n python3-module-%name
Powerful interactive packet manipulation python module scapy.

%prep
%setup

%build
%python3_build

%install
%python3_install
rm -rf %buildroot%python3_sitelibdir/%name/arch/windows

%files
%_bindir/*scapy
%_man1dir/*

%files -n python3-module-scapy
%python3_sitelibdir/%name/
%python3_sitelibdir/%name-*egg-info

%changelog
