%define _unpackaged_files_terminate_build 1

Name: sdcc
Epoch: 1
Version: 3.9.0
Release: alt2
Group: Development/C
URL: http://sdcc.sourceforge.net
License: GPL
Summary: Small Device C Compiler

Source: %name-%version.tar

Patch1: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: flex gcc-c++ boost-devel gputils /usr/bin/makeinfo
BuildRequires: zlib-devel
BuildRequires: /usr/bin/python3

Requires: %name-common = %EVR

%description
SDCC is a free open source, retargettable, optimizing ANSI C compiler
suite that targets a growing list of processors including the Intel
MCS51 based microprocessors (8031, 8032, 8051, 8052, etc.), Maxim
(formerly Dallas) DS80C390 variants, Freescale (formerly Motorola)
HC08 based (hc08, s08) and Zilog Z80 based MCUs (z80, z180, gbz80,
Rabbit 2000/3000, Rabbit 3000A). Work is in progress on supporting
the Microchip PIC16 and PIC18 targets. It can be retargeted for other
microprocessors.

%package common
License: GPL, LGPL
Group:   Development/C
Summary: Libraries and Header Files for the SDCC C compiler

%description common
SDCC is a free open source, retargettable, optimizing ANSI C compiler
suite that targets a growing list of processors including the Intel
MCS51 based microprocessors (8031, 8032, 8051, 8052, etc.), Maxim
(formerly Dallas) DS80C390 variants, Freescale (formerly Motorola)
HC08 based (hc08, s08) and Zilog Z80 based MCUs (z80, z180, gbz80,
Rabbit 2000/3000, Rabbit 3000A). Work is in progress on supporting
the Microchip PIC16 and PIC18 targets. It can be retargeted for other
microprocessors.

%package doc
License:   GPL
Group:     Development/C
Summary:   Documentation for the SDCC C compiler
BuildArch: noarch

%description doc
SDCC is a free open source, retargettable, optimizing ANSI C compiler
suite that targets a growing list of processors including the Intel
MCS51 based microprocessors (8031, 8032, 8051, 8052, etc.), Maxim
(formerly Dallas) DS80C390 variants, Freescale (formerly Motorola)
HC08 based (hc08, s08) and Zilog Z80 based MCUs (z80, z180, gbz80,
Rabbit 2000/3000, Rabbit 3000A). Work is in progress on supporting
the Microchip PIC16 and PIC18 targets. It can be retargeted for other
microprocessors.

%prep
%setup
%patch1 -p1

%build
PYTHON=python3 \
%configure \
	--docdir=%_docdir/%name-%version \
	--enable-werror=no \
	%nil

%make_build

%install
%makeinstall_std

%files 
%_bindir/*

%files common
%_datadir/%name

%files doc
%_docdir/%name-%version

%changelog
