%define policy_name alt
%define date 20201102
%define seconf %_sysconfdir/selinux/config
%define default_mode permissive

Summary: SELinux %policy_name policy
Name: selinux-policy-alt
Version: 0.0.52
Release: alt1
License: Distributable
Group: System/Base
Source: %name-%date.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-licenses
Requires(pre): libsemanage
Requires(pre): policycoreutils
Requires(pre): policycoreutils-newrole

Requires: policycoreutils-newrole
Requires: checkpolicy
Requires: policycoreutils-mcstransd
Requires: policycoreutils-restorecond
Requires: libshell
Requires: m4
Requires: netlabel_tools
Requires: setools-console
Conflicts: selinux-policy-altlinux
Conflicts: selinux-policy
Obsoletes: selinux-policy-altlinux
Provides: selinux-policy-altlinux

%define policy_conf %_sysconfdir/selinux/%policy_name
%define policy_data %_datadir/selinux/%policy_name

%set_findreq_skiplist /lib/systemd/selinux-autorelabel
%add_findreq_skiplist %_bindir/slrun2

%description
SELinux %policy_name policy

%prep 
%setup -n %name

%install
mkdir %buildroot
cp -a * %buildroot

# Ghost files. Do not actually pack them.
tmpfile=$(mktemp)
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/contexts/files/file_contexts
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/contexts/files/file_contexts.bin
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/contexts/files/file_contexts.homedirs
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/contexts/files/file_contexts.homedirs.bin
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/contexts/files/file_contexts.local
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/contexts/files/file_contexts.local.bin
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/contexts/netfilter_contexts
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/semanage.read.LOCK
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/semanage.trans.LOCK
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/seusers
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/policy/policy.28
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/policy/policy.29
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/base.pp
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/commit_num
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/file_contexts
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/file_contexts.homedirs
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/file_contexts.template
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/homedir_template
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/netfilter_contexts
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/seusers
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/policy.kern
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/seusers.final
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/users_extra
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/policy/policy.28
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/policy/policy.29

# modules
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/modules/dolphin.pp
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/modules/xorg.pp
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/modules/psql.pp
install -D -m0644 "$tmpfile" %buildroot/%policy_conf/modules/active/modules/allow_smb.pp

#
# %%post
#

%post

# XXX bug in 'semodule'
mkdir -p %policy_conf/contexts/files
touch %policy_conf/contexts/files/file_contexts.local
# XXX

# Check SeLinux mode and status
# Possible cases:
# 1. SeLinux is enabled, Enforcing is On, current policy is active
# 2. SeLinux is enabled, Enforcing if Off, current policy is active
# 3. SeLinux is enabled, Enforcing is On, another policy is active
# 4. SeLinux is enabled, Enforcing is Off, another policy is active
# 5. SeLinux is disabled

enforce_mode="$(getenforce)"
echo -e "\tCurrent SeLinux enforce mode is: $enforce_mode"

if ! selinuxenabled; then
   echo -e "\tSeLinux is disabled."
fi

# Cleanup previous modules. Existing modules may be a problem to install base policy.
modules="$(semodule -l -s %policy_name | sed -n -e '/[[:digit:]]\+\.[[:digit:]]\+\.[[:digit:]]\+/ s/[[:space:]].*$//p' | tr '\n' ' ' )"
if [ -n "${modules// /}" ]; then
    echo -e "\tRemove all current (even 3rd party) modules for '%policy_name' policy:"
fi
for i in $modules; do
    echo -e "\t\t* Remove previous module '$i'"
    semodule -n -s %policy_name -r $i
done

# Always install new policy
semodule -n -s %policy_name -i %policy_data/base.pp

# Always install all modules
echo -e "\tActivate modules for '%policy_name' policy:"
for i in %policy_data/modules/*.pp; do
    echo -e "\t\t* Install module '$(basename "$i")'" 
    semodule -n -s %policy_name -i "$i"
done

policy_name_active="$(sestatus | sed -n -e '/policy name/ s/^.\+[[:space:]]//p')"
# Upgrade
if [ $1 -eq 2 ]; then
    if [ "$policy_name_active" = "%policy_name" ]; then
        echo -e "\tSeLinux policy has been updated. Please do a reboot."
    fi
fi

# XXX: suppose there are no other working policy.
# Install
if [ $1 -eq 1 ]; then
    echo "Warning:"
    echo -e "\tSeLinux config '%seconf' is updated with 'SELINUX=%default_mode'"
    ( . shell-config; shell_config_set "%seconf" "SELINUX" "%default_mode" )
    ( . shell-config; shell_config_set "%seconf" "SELINUXTYPE" "%policy_name" )

    # Relabel all FileSystem
    echo -e "\tMake sure to:"
    echo -e "\t\t * Enable SeLinux in kernel."
    echo -e "\t\t * Configure PAM for SeLinux."
    echo -e "\tIt is necessary to relabel FS. Please do a reboot."
    echo -e "\tFor more information visit: http://www.altlinux.org/sl"
    touch /.autorelabel
fi

exit 0 # End of %%post section

#
# %%preun
#
%preun

policy_name_active="$(sestatus | sed -n -e '/policy name/ s/^.\+[[:space:]]//p')"

# The last version of a package is erased
if [ $1 = 0 ]; then
    # Cleanup installed modules
    modules="$(semodule -l -s %policy_name | sed -n -e '/[[:digit:]]\+\.[[:digit:]]\+\.[[:digit:]]\+/ s/[[:space:]].*$//p' | tr '\n' ' ' )"
    if [ -n "${modules// /}" ]; then
       echo -e "\tCleanup all installed (even 3rd party) modules for '%policy_name' policy:"
    fi
    for i in $modules; do
       echo -e "\t\t* Cleanup module '$i'"
        semodule -n -s %policy_name -r $i
    done
    if [ "$policy_name_active" = "%policy_name" ]; then
        echo "Warning:"
        echo -e "\tSeLinux is disabled in config: %seconf"
        ( . shell-config; shell_config_set "%seconf" "SELINUX" "disabled" )
        echo -e "\tSeLinux policy package '$policy_name_active' is uninstalled completely."
        echo -e "\tPlease reboot computer as soon as possible."
    fi
fi

exit 0 # End of %%preun section

%files
%doc usr/share/doc/selinux-policy-alt/commit-id
%config(noreplace) %_sysconfdir/selinux/config
%dir %policy_conf
%dir %policy_conf/contexts
%dir %policy_conf/contexts/users
%dir %policy_conf/contexts/files
%dir %policy_conf/modules
%dir %policy_conf/modules/active
%dir %policy_conf/modules/active/modules
%dir %policy_conf/modules/policy
%dir %policy_conf/policy
%dir %policy_data
%dir %policy_data/support
%dir %policy_data/modules
%dir %_sysconfdir/security/alt.newrole

%policy_conf/contexts/dbus_contexts
%policy_conf/contexts/default_contexts
%policy_conf/contexts/default_type
%policy_conf/contexts/x_contexts
%policy_conf/contexts/netfilter_contexts
%policy_conf/contexts/securetty_types
%policy_conf/contexts/sepgsql_contexts
%config(noreplace) %policy_conf/setrans.conf

%policy_conf/contexts/users/*

%policy_data/*.pp
%policy_data/modules/*.pp
%policy_data/*.if

%policy_data/support/*.spt
%policy_data/Makefile

%attr(0755,root,root) %_sysconfdir/security/alt.newrole/helper
%attr(0755,root,root) %_sysconfdir/security/alt.newrole/mkdirs
%config(noreplace) %_sysconfdir/security/alt.newrole/dirs
%config(noreplace) %_sysconfdir/security/alt.newrole/config
%config(noreplace) %_sysconfdir/security/namespace.d/namespace-selinux.conf

%_bindir/slrun
%_bindir/slrun2

/lib/systemd/selinux-autorelabel
%_unitdir/selinux-autorelabel-mark.service
%_unitdir/selinux-autorelabel.service
%_unitdir/sysinit.target.wants/selinux-autorelabel.service
%dir %_unitdir/systemd-modules-load.service.d
%_unitdir/systemd-modules-load.service.d/*.conf

# Files that are auto created at installation step.
# Let's take care of them.
# List them here, to be removed at rpm-remove stage.
%ghost %policy_conf/contexts/files/file_contexts
%ghost %policy_conf/contexts/files/file_contexts.bin
%ghost %policy_conf/contexts/files/file_contexts.homedirs
%ghost %policy_conf/contexts/files/file_contexts.homedirs.bin
%ghost %policy_conf/contexts/files/file_contexts.local
%ghost %policy_conf/contexts/files/file_contexts.local.bin
%ghost %policy_conf/contexts/netfilter_contexts
%ghost %policy_conf/modules/semanage.read.LOCK
%ghost %policy_conf/modules/semanage.trans.LOCK
%ghost %policy_conf/seusers
%ghost %policy_conf/modules/policy/policy.28
%ghost %policy_conf/modules/policy/policy.29
%ghost %policy_conf/modules/active/base.pp
%ghost %policy_conf/modules/active/commit_num
%ghost %policy_conf/modules/active/file_contexts
%ghost %policy_conf/modules/active/file_contexts.homedirs
%ghost %policy_conf/modules/active/file_contexts.template
%ghost %policy_conf/modules/active/homedir_template
%ghost %policy_conf/modules/active/netfilter_contexts
%ghost %policy_conf/modules/active/seusers
%ghost %policy_conf/modules/active/policy.kern
%ghost %policy_conf/modules/active/seusers.final
%ghost %policy_conf/modules/active/users_extra
%ghost %policy_conf/policy/policy.28
%ghost %policy_conf/policy/policy.29

# modules
%ghost %policy_conf/modules/active/modules/dolphin.pp
%ghost %policy_conf/modules/active/modules/xorg.pp
%ghost %policy_conf/modules/active/modules/psql.pp
%ghost %policy_conf/modules/active/modules/allow_smb.pp

%changelog
