Name: shim-signed
Version: 15.4
Release: alt2

Summary: UEFI RestrictedBoot shim signed by Microsoft
License: BSD
Group: System/Kernel and hardware

Url: https://github.com/rhboot/shim
Source: %name-%version.tar

BuildRequires: rpm-macros-uefi
ExclusiveArch: x86_64

%description
This package contains shim binaries signed by "Microsoft
Windows UEFI Driver Publisher" key for both EFI x64 and EFI ia32
architectures. MokManager (as mm*.efi) and fallback (as fb*.efi)
utilities signed by "ALT UEFI SB Signer 2013" are provided as well.

See https://github.com/rhboot/shim-review/issues/47 for details.

%prep
%setup

%install
mkdir -p %buildroot%_efi_bindir %buildroot%_libexecdir/shim
install -p *.efi %buildroot%_efi_bindir/
install -p BOOT*.CSV %buildroot%_libexecdir/shim/
# both should end up within /usr
for pefile in $(ls %buildroot%_efi_bindir/*.efi | rev | cut -d/ -f1 | rev);
  do
	ln %buildroot%_efi_bindir/$pefile \
		%buildroot%_libexecdir/shim/$pefile.signed
  done

%files
%attr(0644,root,root) %_efi_bindir/*.efi
%attr(0644,root,root) %_libexecdir/shim/*.efi.signed
%attr(0644,root,root) %_libexecdir/shim/BOOT*.CSV

%changelog
