Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: /usr/bin/desktop-file-install boost-devel boost-filesystem-devel perl(Class/Accessor.pm) perl(Encode.pm) perl(IO/All.pm) perl(LWP/UserAgent.pm) perl(Math/Trig.pm) perl(OpenGL.pm) perl(PDF/API2.pm) perl(WebService/Prowl.pm) perl-podlators
# END SourceDeps(oneline)
%set_perl_req_method relaxed

# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global use_system_admesh 0
%global use_system_expat 1
%global use_system_polyclipping 1
%global use_system_poly2tri 1

Name:           slic3r
Version:        1.3.0
Release:        alt3_19
Summary:        G-code generator for 3D printers (RepRap, Makerbot, Ultimaker etc.)
License:        AGPLv3 and CC-BY
# Images are CC-BY, code is AGPLv3
URL:            http://slic3r.org/
Source0:        https://github.com/alexrj/Slic3r/archive/%{version}.tar.gz

# Modify Build.PL so we are able to build this on Fedora
Patch0:         %{name}-buildpl.patch

# Use /usr/share/slic3r as datadir
Patch1:         %{name}-datadir.patch
Patch2:         %{name}-english-locale.patch
Patch3:         %{name}-linker.patch
Patch4:         %{name}-clipper.patch
Patch5:         %{name}-1.3.0-fixtest.patch
Patch6:         %{name}-wayland.patch
Patch7:         %{name}-boost169.patch

# Use GCC predefined macros instead of deprecated Boost header
# Upstream already dropped this code in PR#781
Patch8:         %{name}-endian.patch
# Make boost::Placeholders::_1 visible (PR#4976)
Patch9:         %{name}-bind-placeholders.patch
# Use boost/nowide/cstdlib.hpp instead of boost/nowide/cenv.hpp (PR#4976)
Patch10:        %{name}-boost-nowide.patch

# Security fix for CVE-2020-28591
# https://github.com/slic3r/Slic3r/pull/5063
Patch11:        %{name}-CVE-2020-28591.patch

Source1:        %{name}.desktop
Source2:        %{name}.appdata.xml

BuildRequires:  gcc-c++
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Class/XSAccessor.pm)
BuildRequires:  perl(Devel/CheckLib.pm)
BuildRequires:  perl(Devel/Peek.pm)
BuildRequires:  perl(Encode/Locale.pm)
BuildRequires:  perl(ExtUtils/CppGuess.pm)
BuildRequires:  perl(ExtUtils/CBuilder.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(ExtUtils/Typemaps/Default.pm)
BuildRequires:  perl(ExtUtils/Typemaps.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(IO/Scalar.pm)
BuildRequires:  perl(IO/Uncompress/Unzip.pm)
BuildRequires:  perl(List/Util.pm)
BuildRequires:  perl(local/lib.pm)
BuildRequires:  perl(Module/Build/WithXSpp.pm)
BuildRequires:  perl(Moo.pm)
BuildRequires:  perl(parent.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(SVG.pm)
BuildRequires:  perl(Test/Harness.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Thread/Queue.pm)
BuildRequires:  perl(Thread/Semaphore.pm)
BuildRequires:  perl(threads.pm)
BuildRequires:  perl(threads/shared.pm)
BuildRequires:  perl(Time/HiRes.pm)
BuildRequires:  perl(Unicode/Normalize.pm)
BuildRequires:  perl(Wx.pm)

%if %{use_system_admesh}
BuildRequires:  libadmesh-devel >= 0.98.1
Requires:       libadmesh >= 0.98.1
%else
Provides:       bundled(admesh) = 0.98
# Bundled admesh FTBFS with:
# error "admesh works correctly on little endian machines only!"
ExcludeArch:    ppc ppc64 s390 s390x
%endif

%if %{use_system_expat}
BuildRequires:  libexpat-devel >= 2.2.0
%else
Provides:       bundled(expat) = 2.2.0
%endif

%if %{use_system_polyclipping}
BuildRequires:  libpolyclipping-devel >= 6.4.2
%else
Provides:       bundled(polyclipping) = 6.4.2
%endif

%if %{use_system_poly2tri}
BuildRequires:  libpoly2tri-devel
%else
Provides:       bundled(poly2tri) = 0.0
%endif

BuildRequires:  boost-complete
BuildRequires:  libleatherman-devel
BuildRequires:  desktop-file-utils
BuildRequires:  ImageMagick-tools
Requires:       perl(Growl/GNTP.pm) >= 0.150
Requires:       perl(XML/SAX.pm)

# Optional dependency. Not packaged in Fedora yet, hence we cannot list it.
# It's only used for magically finding octoprint servers.
# #Recommends:    perl(Net::Bonjour)

# Optional dependencies to allow background processing.
Requires:     perl(Thread/Queue.pm)
Requires:     perl(threads/shared.pm)
Source44: import.info
# alt bug #34434
Requires:       perl(OpenGL.pm)
Requires:       perl(Class/Accessor.pm)
Requires:       perl(Math/Trig.pm)
Requires:       perl-Wx-GLCanvas

%description
Slic3r is a G-code generator for 3D printers. It's compatible with RepRaps,
Makerbots, Ultimakers and many more machines.
See the project homepage at slic3r.org and the documentation on the Slic3r wiki
for more information.

%prep
%setup -qn Slic3r-%{version}

%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1 -b .linker
%if %{use_system_polyclipping}
%patch4 -p1
%endif
%patch5 -p1 -b .fixtest
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1

# Optional removals
%if %{use_system_admesh}
rm -rf xs/src/admesh
sed -i '/src\/admesh/d' xs/MANIFEST
%endif

%if %{use_system_expat}
rm -rf xs/src/expat
sed -i '/src\/expat/d' xs/MANIFEST
# These are the files with hardcoded expat/expat.h includes
sed -i 's|expat/expat.h|expat.h|g' xs/src/libslic3r/IO/AMF.cpp
sed -i 's|expat/expat.h|expat.h|g' xs/src/libslic3r/IO/TMF.hpp
%endif

%if %{use_system_polyclipping}
#rm xs/src/clipper.*pp
export SYSTEM_LIBS="${SYSTEM_LIBS} -lpolyclipping"
%endif

%if %{use_system_poly2tri}
rm -rf xs/src/poly2tri
sed -i '/src\/poly2tri/d' xs/MANIFEST
%endif

# We always do boost.
rm -rf xs/src/boost
sed -i '/src\/boost\/nowide/d' xs/MANIFEST
sed -i 's|\(ExtUtils::ParseXS\s\+\)3.35|\13.34|' Build.PL xs/Build.PL

%build
%if %{use_system_admesh}
export SYSTEM_LIBS="${SYSTEM_LIBS} -ladmesh"
%endif

%if %{use_system_expat}
export SYSTEM_LIBS="${SYSTEM_LIBS} -lexpat"
%endif

%if %{use_system_poly2tri}
export SYSTEM_LIBS="${SYSTEM_LIBS} -lpoly2tri"
%endif

cd xs
[[ ! -z "${SYSTEM_LIBS}" ]] && echo "SYSTEM_LIBS is ${SYSTEM_LIBS}"
perl ./Build.PL installdirs=vendor optimize="$RPM_OPT_FLAGS"
./Build
cd -
# Building non XS part only runs test, so skip it and run it in tests

# prepare pngs in mutliple sizes
for res in 16 32 48 128 256; do
  mkdir -p hicolor/${res}x${res}/apps
done
cd hicolor
convert ../var/Slic3r.ico %{name}.png
cp %{name}-0.png 256x256/apps/%{name}.png
cp %{name}-1.png 128x128/apps/%{name}.png
cp %{name}-2.png 48x48/apps/%{name}.png
cp %{name}-3.png 32x32/apps/%{name}.png
cp %{name}-4.png 16x16/apps/%{name}.png
rm %{name}-*.png
cd -

# To avoid "iCCP: Not recognized known sRGB profile that has been edited"
cd var
find . -type f -name "*.png" -exec convert {} -strip {} \;
cd -

%install
cd xs
./Build install destdir=%{buildroot} create_packlist=0
cd -
find %{buildroot} -type f -name '*.bs' -size 0 -exec rm -f {} \;

# I see no way of installing slic3r with it's build script
# So I copy the files around manually
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{perl_vendor_privlib}
mkdir -p %{buildroot}%{_datadir}/%{name}
mkdir -p %{buildroot}%{_datadir}/icons
mkdir -p %{buildroot}%{_datadir}/appdata

cp -a %{name}.pl %{buildroot}%{_bindir}/%{name}
cp -ar lib/* %{buildroot}%{perl_vendor_privlib}

cp -a var/* %{buildroot}%{_datadir}/%{name}
cp -r hicolor %{buildroot}%{_datadir}/icons
desktop-file-install --dir=%{buildroot}%{_datadir}/applications %{SOURCE1}

cp %{SOURCE2} %{buildroot}%{_datadir}/appdata/%{name}.appdata.xml

# %{_fixperms} %{buildroot}*

%check
cd xs
./Build test verbose=1
cd -
SLIC3R_NO_AUTO=1 perl Build.PL installdirs=vendor
# the --gui runs no tests, it only checks requires

%files
%doc README.md
%{_bindir}/%{name}
%{perl_vendor_privlib}/Slic3r*
%{perl_vendor_archlib}/Slic3r*
%{perl_vendor_archlib}/auto/Slic3r*
%{_datadir}/icons/hicolor/*/apps/%{name}.png
%{_datadir}/applications/%{name}.desktop
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/%{name}

%changelog
