%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%ifarch %e2k ppc64le
%def_disable qtwebengine
%else
%def_enable qtwebengine
%endif

%define slicerver 4.11

Name: slicer
Version: %slicerver.20210226
Release: alt3.1
Summary: Multi-platform, free open source software for visualization and image computing
License: BSD-like
Group: Sciences/Medicine
Url: https://www.slicer.org/

ExcludeArch: %arm

# https://github.com/Slicer/Slicer.git
Source: %name-%version.tar

# Downloaded from link specified in SuperBuild.cmake
Source1: %name-%version-jqPlot.tar

# Copied from CTK
Source2: FindPythonQt.cmake

Source3: slicer.desktop

Patch1: %name-alt-build.patch
Patch2: %name-alt-python3-compat.patch
Patch3: %name-upstream-python39-compat.patch
Patch4: %name-alt-gcc11-compat.patch

BuildRequires(pre): rpm-macros-qt5
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: gcc-c++ cmake
BuildRequires: qt5-base-devel qt5-multimedia-devel qt5-script-devel qt5-svg-devel qt5-tools-devel-static qt5-xmlpatterns-devel
%if_enabled qtwebengine
BuildRequires: qt5-webengine-devel
%endif
BuildRequires: libitk-devel
BuildRequires: libvtk-devel
BuildRequires: CTK-devel
BuildRequires: teem-devel
BuildRequires: vtkaddon-devel
BuildRequires: slicerexecutionmodel-devel
BuildRequires: libcurl-devel
BuildRequires: libqrestapi-devel
BuildRequires: CTKAppLauncherLib-devel
BuildRequires: pythonqt-devel
BuildRequires: rapidjson-devel
BuildRequires: bzip2-devel
BuildRequires: libniftilib-devel liblpsolve-devel
BuildRequires: doxygen /usr/bin/dot

%add_python3_path %_libdir/Slicer-%slicerver

%add_python3_req_skip EditorLib
%add_python3_req_skip SegmentEditorEffects SegmentEditorEffects.AbstractScriptedSegmentEditorEffect SegmentEditorEffects.AbstractScriptedSegmentEditorLabelEffect
%add_python3_req_skip Slicer slicer slicer.ScriptedLoadableModule slicer.util
%add_python3_req_skip SimpleITK __main__ github github.GithubObject

%description
What is 3D Slicer ?

Desktop software to solve advanced image computing challenges
with a focus on clinical and biomedical applications.

Development platform to quickly build and deploy custom solutions
for research and commercial products, using free, open source software.

Community of knowledgeable users and developers working together
to improve medical computing.

%package devel
Summary: Multi-platform, free open source software for visualization and image computing
Group: Development/C++
Requires: %name = %EVR
Requires: %name-qt5-designer-plugin = %EVR

%description devel
What is 3D Slicer ?

Desktop software to solve advanced image computing challenges
with a focus on clinical and biomedical applications.

Development platform to quickly build and deploy custom solutions
for research and commercial products, using free, open source software.

Community of knowledgeable users and developers working together
to improve medical computing.

This package contains development files for Slicer.

%package qt5-designer-plugin
Summary: Multi-platform, free open source software for visualization and image computing
Group: Development/C++

%description qt5-designer-plugin
What is 3D Slicer ?

Desktop software to solve advanced image computing challenges
with a focus on clinical and biomedical applications.

Development platform to quickly build and deploy custom solutions
for research and commercial products, using free, open source software.

Community of knowledgeable users and developers working together
to improve medical computing.

This package contains Slicer plugins for qt5 designer.

%prep
%setup -a1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

install %SOURCE2 ./CMake/

# change python shebangs to python3
find . -name '*.py' | xargs sed -i \
	-e '1s|^#!/usr/bin/env python$|#!/usr/bin/env python3|' \
	-e '1s|^#!/usr/bin/python$|#!/usr/bin/python3|' \
	%nil

%build
%add_optflags -D_FILE_OFFSET_BITS=64

jqplotdir="$(pwd)/jqPlot"

%cmake \
	-DSlicer_DEFAULT_RELEASE_TYPE:STRING=Stable \
	-DSlicer_VTK_VERSION_MAJOR=9 \
	-DSlicer_SUPERBUILD:BOOL=OFF \
	-DSlicer_BUILD_I18N_SUPPORT:BOOL=ON \
	-DSlicer_INSTALL_DEVELOPMENT:BOOL=ON \
	-DSlicer_INSTALL_NO_DEVELOPMENT:BOOL=OFF \
	-DSlicer_WITH_LIBRARY_VERSION:BOOL=ON \
	-DBUILD_TESTING:BOOL=OFF \
	-DSlicer_USE_PYTHONQT:BOOL=ON \
	-DjqPlot_DIR:PATH="${jqplotdir}" \
	-DSlicer_USE_QtTesting:BOOL=OFF \
	-DSlicer_USE_SYSTEM_DCMTK:BOOL=ON \
	-DSlicer_USE_SYSTEM_CTK:BOOL=ON \
	-DSlicer_USE_SYSTEM_OpenSSL:BOOL=ON \
	-DSlicer_USE_SYSTEM_TBB:BOOL=ON \
	-DSlicer_USE_SYSTEM_python:BOOL=ON \
	-DSlicer_USE_SYSTEM_QT:BOOL=ON \
	-DSlicer_BUILD_WEBENGINE_SUPPORT:BOOL=%{?_enable_qtwebengine:ON}%{!?_enable_qtwebengine:OFF} \
	-DSlicer_USE_SYSTEM_LibArchive:BOOL=ON \
	-DSlicerExecutionModel_DEFAULT_CLI_INSTALL_RUNTIME_DESTINATION:PATH=%_libdir/Slicer-%slicerver/cli-modules \
	-DSlicerExecutionModel_DEFAULT_CLI_INSTALL_LIBRARY_DESTINATION:PATH=%_libdir/Slicer-%slicerver/lib/Slicer-%slicerver/cli-modules \
	-DSlicer_STORE_SETTINGS_IN_APPLICATION_HOME_DIR:BOOL=OFF \
	%nil

%cmake_build

%install
%cmakeinstall_std

install -d %buildroot%_bindir
cat > %buildroot%_bindir/Slicer << END
#!/bin/sh
exec %_libdir/Slicer-%slicerver/Slicer "\$@"
END

chmod +x %buildroot%_bindir/Slicer

# install symlinks for library discovery: they are loaded dynamically, but they have dependencies on each other as well
# separate library is used for dynamic loading, symlink in generic directory is used for loading as dependency
install -d %buildroot%_libdir
find %buildroot%_libdir/Slicer-%slicerver -name '*.so*' | while read i ; do
	ln -sr $i %buildroot%_libdir/
done

# install desktop file and icon
install -d %buildroot%_desktopdir
install -m644 %SOURCE3 %buildroot%_desktopdir/

install -d %buildroot%_datadir/%name
install -m644 Resources/3DSlicer-DesktopIcon.png %buildroot%_datadir/%name/

# remove unpackaged files
find %buildroot%_libdir -name '*.a' -delete

# generated cmake files require a lot of fixing before they'd become useable
rm -rf %buildroot%_libdir/cmake
rm -rf %buildroot%_libdir/Slicer-%slicerver/lib/Slicer-%slicerver/cmake

# fix qt designer launch
ln -sr %buildroot%_bindir/designer-qt5 %buildroot%_libdir/Slicer-%slicerver/bin/designer-real

%files
%doc COPYRIGHT.txt License.txt
%doc README.txt CONTRIBUTING.md AUTHORS.rst
%_bindir/Slicer
%_libdir/*.so
%_libdir/*.so.*
%dir %_libdir/Slicer-%slicerver
%_libdir/Slicer-%slicerver/Slicer
%_libdir/Slicer-%slicerver/bin
%_libdir/Slicer-%slicerver/cli-modules
%_libdir/Slicer-%slicerver/lib
%_libdir/Slicer-%slicerver/libexec
%_libdir/Slicer-%slicerver/share
%_qt5_plugindir/iconengines/*.so
%_qt5_plugindir/styles/*.so
%_datadir/MRMLCore
%_desktopdir/*.desktop
%dir %_datadir/%name
%_datadir/%name/3DSlicer-DesktopIcon.png

%files devel
%_includedir/*

%files qt5-designer-plugin
%_qt5_plugindir/designer/*.so

%changelog
