%def_with doxygen
%def_without check
%def_disable static
%define major 1.13

Name: sofia-sip
Version: 1.13.17
Release: alt1
BuildRequires:  gcc-c++
BuildRequires:  openssl-devel >= 0.9.7
BuildRequires:  glib2-devel >=  2.4
BuildRequires:  lksctp-tools
BuildRequires:  autoconf
BuildRequires:  automake

Summary: Sofia SIP User-Agent library 
License: LGPLv2.1
Group: System/Libraries
Url: http://sofia-sip.sourceforge.net/
VCS: https://github.com/freeswitch/sofia-sip

Source: %name-%version.tar
Patch0: %name-%version-%release.patch

BuildRequires: glib2-devel libssl-devel %{?_with_doxygen: doxygen graphviz fonts-ttf-liberation} %{?_with_check: libcheck-devel}

%description
Sofia SIP is a RFC-3261-compliant library for SIP user agents and other
network elements.

%package -n libsofia-sip
Summary: Sofia SIP User-Agent library
Group: System/Libraries
Provides: sofia-sip
Obsoletes: sofia-sip

%package -n libsofia-sip-devel
Summary: Sofia-SIP Development Package
Group: Development/C
Requires: libsofia-sip = %version-%release

%package -n libsofia-sip-glib
Summary: GLIB bindings for Sofia-SIP 
Group: System/Libraries
Requires: libsofia-sip = %version-%release
Provides: sofia-sip-glib
Obsoletes: sofia-sip-glib

%package -n libsofia-sip-glib-devel
Summary: GLIB bindings for Sofia SIP development files
Group: Development/C
Requires: libsofia-sip-glib = %version-%release
Requires: libsofia-sip-devel = %version-%release

%package docs
Summary: Sofia-SIP Development Manual Package
Group: Documentation
BuildArch: noarch

%package utils
Summary: Sofia-SIP Command Line Utilities
Group: Networking/Other
Requires: libsofia-sip = %version-%release

%description -n libsofia-sip
Sofia SIP is a RFC-3261-compliant library for SIP user agents and other
network elements.

%description -n libsofia-sip-devel
Development package for Sofia SIP UA library. This package includes 
static libraries and include files.

%description -n libsofia-sip-glib
GLib interface to Sofia SIP User Agent library.

%description -n libsofia-sip-glib-devel
Development package for Sofia SIP UA Glib library. This package includes
static libraries and include files for developing glib programs using Sofia
SIP.

%description docs
HTML reference documentation for Sofia SIP UA library.

%description utils
Command line utilities for Sofia SIP UA library.

%prep
%setup
%patch0 -p1

%build
%autoreconf
%configure --disable-sctp %{subst_enable static}
make all %{?_with_doxygen: doxygen} %{?_with_check: check}
%if_with doxygen
pushd utils
doxygen
popd
%endif

%install
%make_install DESTDIR=%buildroot install

%if_with doxygen
cp -pr libsofia-sip-ua/docs/html manual
mkdir -p %buildroot/%_man1dir
install -pm0644 man/man1/* %buildroot/%_man1dir/
%endif

%files -n libsofia-sip
%doc AUTHORS COPYRIGHTS README* RELEASE TODO
%_libdir/libsofia-sip-ua.so.*

%files -n libsofia-sip-glib
%_libdir/libsofia-sip-ua-glib.so.*

%files -n libsofia-sip-devel
%_libdir/libsofia-sip-ua.so

%_includedir/sofia-sip-%major
%exclude %_includedir/sofia-sip-%major/sofia-sip/su_glib.h
%exclude %_includedir/sofia-sip-%major/sofia-sip/su_source.h

%_datadir/sofia-sip

%_pkgconfigdir/sofia-sip-ua.pc

%files -n libsofia-sip-glib-devel
%_libdir/libsofia-sip-ua-glib.so

%_includedir/sofia-sip-%major/sofia-sip/su_glib.h
%_includedir/sofia-sip-%major/sofia-sip/su_source.h

%_pkgconfigdir/sofia-sip-ua-glib.pc

%if_with doxygen
%files docs
%doc manual
%endif

%files utils
%_bindir/localinfo
%_bindir/addrinfo
%_bindir/sip-options
%_bindir/sip-date
%_bindir/sip-dig
%_bindir/stunc
%_man1dir/*

%changelog
