Name: speech-dispatcher
Version: 0.10.2
Release: alt1

Summary: A speech output processing service
License: %gpl2plus
Group: Sound
URL: http://www.freebsoft.org/speechd

Source: http://devel.freebsoft.org/pub/projects/speechd/%name-%version.tar
# fc
Source1: %{name}d.service
Patch: speech-dispatcher-0.8-alt-flite.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires: libdotconf-devel >= 0.3
BuildRequires: gcc-c++ glib2-devel glibc-devel-static intltool
BuildRequires: libXau-devel  libltdl7-devel
BuildRequires: libalsa-devel libao-devel
BuildRequires: flite-devel  libespeak-devel svox-pico
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-base python3-devel
BuildRequires: libsndfile-devel libpulseaudio-devel
BuildRequires: makeinfo

%add_python3_req_skip speechd_config
%add_python3_req_skip xdg

%description
Speech Dispatcher is a part of the Free(b)soft project, which is
intended to allow blind and visually impaired people to work with
computer and Internet based on free software.

%package -n libspeechd
Summary: Client library for speech-dispatcher
Group: System/Libraries

%description -n libspeechd
Applications can use this library to communicate with speech-dispatcher
service and produce speech output.

%package -n libspeechd-devel
Group: Development/C
Summary: Development files to use libspeechd to connect to speech-dispatcher

%description -n libspeechd-devel
Developers can use this library to connect to speech-dispatcher daemon
and produce speech output.

%package utils
Group: Sound
Summary: Various utilities for speech-dispatcher
Requires: %name = %version-%release

%description utils
Various utilities for speech-dispatcher

%package module-flite
Group: Sound
Summary: Flite support for speech-dispatcher
Requires: %name = %version-%release

%description module-flite
Flite support for speech-dispatcher

%package module-festival
Group: Sound
Summary: Festival support for speech-dispatcher
Requires: %name = %version-%release

%description module-festival
Festival support for speech-dispatcher

%package module-pico
Group: Sound
Summary: Pico support for speech-dispatcher
Requires: %name = %version-%release

%description module-pico
Pico support for speech-dispatcher

%package -n python3-module-speechd
Summary: Python client for Speech Dispatcher
Group: Development/Python
BuildArch: noarch
Requires: %name = %version-%release

%description -n python3-module-speechd
This python module allows programmsaccess speech-dispatcher service.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure --with-espeak \
	   --with-flite  \
           --with-pico \
	   --with-pulse \
	   --with-alsa \
	   --with-libao \
	   --with-oss \
	   --without-voxin \
	   --without-kali \
	   --without-ibmtts \
	   --without-baratinoo
%make_build

%install
%make_install DESTDIR='%buildroot' pyexecdir=%python3_sitelibdir_noarch install

# service file
install -D -p -m644 %SOURCE1 %buildroot%_unitdir/%{name}d.service

%find_lang %name

%files -f %name.lang
%doc FAQ NEWS README.md README.overview.md
%_bindir/speech-dispatcher
%config %_sysconfdir/%name
%_unitdir/%{name}d.service
%dir %_libdir/%name
%_libdir/%name/spd*.so
%exclude %_libdir/%name/spd_alsa.*a
%dir %_libdir/%name-modules
%_libdir/%name-modules/sd_dummy
%_libdir/%name-modules/sd_espeak
%_libdir/%name-modules/sd_generic
%_libdir/%name-modules/sd_cicero
%_datadir/sounds/%name
%_datadir/%name
%_infodir/*

%files -n libspeechd
%_libdir/libspeechd*.so.*
%exclude %_libdir/libspeechd.*a

%files -n libspeechd-devel
%_includedir/*
%_libdir/libspeechd.so
%_pkgconfigdir/*

%files utils
%_bindir/spd-conf
%_bindir/spd-say
%_bindir/spdsend

%files module-flite
%_libdir/%name-modules/sd_flite

%files module-festival
%_libdir/%name-modules/sd_festival

%files module-pico
%_libdir/%name-modules/sd_pico

%files -n python3-module-speechd
%python3_sitelibdir_noarch/*

%changelog
