# CMake option USE_PLUGIN_TELESCOPECONTROL
# requires libindi API incompatible with codebase
%def_without telescopecontrol

Name: stellarium
Version: 24.3
Release: alt0.p10.1

Summary: Astronomical Sky Simulator

License: GPLv2
Group: Education
Url: http://www.stellarium.org/

Source: %name-%version.tar
# Adds system provided "fast_float" headers.
# gcc10 could not pass check using built-in float functions.
# CMake trying to find installed headers now.
Patch0: stellarium-24.3-alt-system-provided-fast_float.patch

BuildRequires(pre): rpm-macros-cmake rpm-macros-qt5-webengine

BuildRequires: cmake ctest gcc-c++
BuildRequires: qt5-base-devel
BuildRequires: libCalcMySky-devel
BuildRequires: pkgconfig(Qt5Charts)
BuildRequires: pkgconfig(Qt5SerialPort)
BuildRequires: pkgconfig(Qt5Multimedia)
BuildRequires: pkgconfig(Qt5Positioning)
BuildRequires: libQXlsx-devel
BuildRequires: doxygen
%if_with telescopecontrol
BuildRequires: pkgconfig(libindi)
%endif
BuildRequires: pkgconfig(nlopt)
BuildRequires: pkgconfig(Qt5Script)
BuildRequires: pkgconfig(Qt5Help)
BuildRequires: pkgconfig(exiv2)
BuildRequires: pkgconfig(zlib)
BuildRequires: pkgconfig(expat)
BuildRequires: perl-podlators
%ifarch %qt5_qtwebengine_arches
BuildRequires: pkgconfig(Qt5WebEngineWidgets)
%endif
BuildRequires: libfast_float-devel

ExcludeArch: armh

%ifnarch %e2k
%define _optlevel s
%endif

%description
Stellarium is a free software available for Windows, Linux/Unix and MacOSX.
It renders 3D photo-realistic skies in real time. With stellarium, you
really see what you can see with your eyes, binoculars or a small
telescope.

%prep
%setup
%patch0 -p1
%ifarch %e2k
# lcc doesn't ignore unicode bom
find -type f -print0 | xargs -r0 -- sed -i '1s/^\xEF\xBB\xBF//'
%endif

%build
%cmake \
%if_without telescopecontrol
       -DUSE_PLUGIN_TELESCOPECONTROL=NO \
%endif
%ifarch %qt5_qtwebengine_arches
       -DENABLE_TESTING=YES \
%endif
       -DENABLE_QT6=NO \
       -DCMAKE_INSTALL_PREFIX=/usr
%cmake_build

%install
%cmake_install

# See ALT 25353
find %buildroot -name 'DejaVuSans*.ttf' -delete

%find_lang %name
%find_lang %name-skycultures

%check
# Floating point tests fails on %%ix86 arches
%ifarch %qt5_qtwebengine_arches
# FIXME: Watch the upstream issue #2591.
# Broken test excluded from suite.
%ctest -E testCalendars
%endif

%files -f %name.lang
%doc ChangeLog README*
%_bindir/%name
%_datadir/%name
%_mandir/man1/%name.1.xz
%_datadir/applications/*.desktop
%_datadir/metainfo/*.appdata.xml
%_datadir/icons/hicolor/*/apps/%name.png
%_datadir/mime/packages/stellarium.xml

%changelog
