#set capability dropping library.
#Currently supported values are "libcap" and "native".
%define capabilities libcap
%def_enable addrblock
%def_enable agent
%def_enable ccm
%def_enable cisco_quirks
%def_enable cmd
%def_enable ctr
%def_enable curl
%def_enable dhcp
%def_enable eap_aka
%def_enable eap_gtc
%def_enable eap_identity
%def_enable eap_md5
%def_enable eap_mschapv2
%def_enable eap_radius
%def_enable eap_sim
%def_enable eap_sim-file
%def_enable eap_tls
%def_enable eap_tnc
%def_enable eap_ttls
%def_enable farp
%def_enable gcm
%def_enable ha
%def_enable kernel_klips
%def_enable kernel_netlink
%def_enable kernel_pfkey
%def_enable ldap
%def_enable medcli
%def_enable mediation
%def_enable nat_transport
%def_enable ntru
%def_enable openssl
%def_enable pkcs11
%def_enable self_test
%def_enable smartcard
%def_enable smp
%def_enable sql
%def_enable stroke
%def_enable swanctl
%def_disable dumm
%def_disable load_tests
%def_disable manager
%def_disable medsrv
%def_disable mysql
%def_enable nm
%def_disable sqlite
%def_disable static
%def_disable uci
%def_disable unit_tests
# this one requires that libhydra and libcharon be
# underlinked on purpose, contact mike@ for email
# explanation by Tobias Brunner (11 May 2010)
%def_disable integrity-test

%ifarch %ix86
%def_enable padlock
%else
%def_disable padlock
%endif

%define beta %nil

Name: strongswan
Version: 5.9.13
Release: alt1

Summary: strongSwan IPsec implementation
License: GPLv2+
Group: System/Servers

# git://git.strongswan.org/strongswan.git
Url: http://www.strongswan.org
Source0: %name-%version%beta.tar.gz
Source1: ipsec.init
Source2: ipsec.service
Source100: strongswan.watch
Packager: Michael Shigorin <mike@altlinux.org>

# Automatically added by buildreq on Mon Jul 02 2012
# optimized out: pkg-config
BuildRequires: flex gperf libcap-devel libcurl-devel libgmp-devel libldap-devel libpam-devel libssl-devel libxml2-devel
BuildRequires: pkgconfig(systemd)

%if_enabled nm
BuildRequires: libnm-devel
%endif

Provides: libstrongswan = %version-%release
Obsoletes: libstrongswan < 4.3

%define pkgdocdir %_docdir/%name-%version
%add_verify_elf_skiplist %_libdir/ipsec/plugins/*.so

%description
strongSwan is a free implementation of IPsec & IKE for Linux. IPsec is the
Internet Protocol Security and uses strong cryptography to provide both
authentication and encryption services. These services allow you to build
secure tunnels through untrusted networks. Everything passing through the
untrusted net is encrypted by the ipsec gateway machine and decrypted by the
gateway at the other end of the tunnel. The resulting tunnel is a virtual
private network or VPN.

This package contains the service and userland tools for setting up strongSwan
on a freeswan enabled kernel.

%package testing
Summary: %name testing
Group: Documentation
Requires: %name = %version
BuildArch: noarch

%description testing
This package contains testing scripts and configuration snippets
of strongSwan documentation

%package charon-nm
Summary: NetworkManager plugin for Strongswan
Group: System/Servers

%description charon-nm
NetworkManager plugin integrates a subset of Strongswan capabilities
to NetworkManager.

%prep
%setup -n %name-%version%beta

%build
%autoreconf
%configure \
	--sysconfdir=%_sysconfdir/%name \
	--libexecdir=%_libdir/%name \
	--bindir=%_libexecdir/%name \
	%{subst_enable addrblock} \
	%{subst_enable agent} \
	%{subst_enable ccm} \
	%{subst_enable cmd} \
	%{subst_enable ctr} \
	%{subst_enable curl} \
	%{subst_enable dhcp} \
	%{subst_enable dumm} \
	%{subst_enable farp} \
	%{subst_enable gcm} \
	%{subst_enable ha} \
	%{subst_enable ldap} \
	%{subst_enable manager} \
	%{subst_enable medcli} \
	%{subst_enable mediation} \
	%{subst_enable medsrv} \
	%{subst_enable mysql} \
	%{subst_enable ntru} \
	%{subst_enable openssl} \
	%{subst_enable padlock} \
	%{subst_enable smartcard} \
	%{subst_enable smp} \
	%{subst_enable sql} \
	%{subst_enable sqlite} \
	%{subst_enable static} \
	%{subst_enable stroke} \
	%{subst_enable swanctl} \
	%{subst_enable uci} \
	%{subst_enable nm} \
	--with-capabilities=%capabilities \
	%{subst_enable pkcs11} \
	--with-default-pkcs11=%_libdir/pkcs11/opensc-pkcs11.so \
	%{?_enable_cisco_quirks: --enable-cisco-quirks} \
	%{?_enable_unit_tests: --enable-unit-tests} \
	%{?_enable_load_tests: --enable-load-tests} \
	%{?_enable_eap_radius: --enable-eap-radius} \
	%{?_enable_eap_identity: --enable-eap-identity} \
	%{?_enable_eap_mschapv2: --enable-eap-mschapv2} \
	%{?_enable_eap_tls: --enable-eap-tls} \
	%{?_enable_eap_ttls: --enable-eap-ttls} \
	%{?_enable_eap_tnc: --enable-eap-tnc} \
	%{?_enable_eap_sim: --enable-eap-sim} \
	%{?_enable_eap_sim_file: --enable-eap-sim-file} \
	%{?_enable_eap_md5: --enable-eap-md5} \
	%{?_enable_eap_gtc: --enable-eap-gtc} \
	%{?_enable_eap_aka: --enable-eap-aka} \
	%{?_enable_kernel_netlink: --enable-kernel-netlink} \
	%{?_enable_kernel_pfkey: --enable-kernel-pfkey} \
	%{?_enable_kernel_klips: --enable-kernel-klips} \
	%{?_enable_nat_transport: --enable-nat-transport} \
	%{?_enable_integrity_test: --enable-integrity-test} \
	%{?_enable_self_test: --enable-self-test}

#
%make_build

%install
%makeinstall_std
mkdir -p %buildroot{%pkgdocdir,%systemd_unitdir}

install -pDm755 %SOURCE1 %buildroot%_initdir/ipsec
install -pm644 %SOURCE2 %buildroot%systemd_unitdir/
install -pm644 ChangeLog NEWS README TODO %buildroot%pkgdocdir/
rm -f %buildroot%_libdir/lib%name.{a,so}
rm -f testing/do-tests* testing/Makefile.*
cp -a testing/ %buildroot%pkgdocdir/

# It is the file in the package whose name matches the format emacs or vim uses 
# for backup and autosave files. It may have been installed by  accident.
find $RPM_BUILD_ROOT \( -name '.*.swp' -o -name '#*#' -o -name '*~' \) -print -delete
# failsafe cleanup if the file is declared as %%doc
find . \( -name '.*.swp' -o -name '#*#' -o -name '*~' \) -print -delete

%files
%dir %pkgdocdir
%pkgdocdir/[A-Z]*
%attr(700,root,root) %dir %_sysconfdir/%name
%attr(700,root,root) %dir %_sysconfdir/%name/ipsec.d/
%attr(700,root,root) %dir %_sysconfdir/%name/ipsec.d/acerts
%attr(700,root,root) %dir %_sysconfdir/%name/ipsec.d/aacerts
%attr(700,root,root) %dir %_sysconfdir/%name/ipsec.d/ocspcerts
%attr(700,root,root) %dir %_sysconfdir/%name/ipsec.d/certs
%attr(700,root,root) %dir %_sysconfdir/%name/ipsec.d/cacerts
%attr(700,root,root) %dir %_sysconfdir/%name/ipsec.d/crls
%attr(700,root,root) %dir %_sysconfdir/%name/ipsec.d/private
%attr(700,root,root) %dir %_sysconfdir/%name/%name.d/*/
%attr(700,root,root) %dir %_sysconfdir/%name/%name.d/
%attr(700,root,root) %dir %_sysconfdir/%name/swanctl/
%config(noreplace) %_sysconfdir/%name/swanctl/swanctl.conf
%config(noreplace) %_sysconfdir/%name/%name.d/*/*.conf
%config(noreplace) %_sysconfdir/%name/%name.d/*.conf
%config(noreplace) %_sysconfdir/%name/%name.conf
%config(noreplace) %_sysconfdir/%name/ipsec.conf
%config(noreplace) %_sysconfdir/%name/ipsec.secrets
%config(noreplace) %_initdir/ipsec
%_unitdir/ipsec.service
%_unitdir/strongswan-starter.service
%_datadir/%name/
%dir %_libdir/%name/
%dir %_libdir/%name/ipsec/
%_libdir/%name/ipsec/charon
%_libdir/%name/ipsec/starter
%_libdir/%name/ipsec/stroke
%_libdir/%name/ipsec/_updown
%_libdir/%name/ipsec/xfrmi
%_libdir/ipsec/
%_sbindir/charon-cmd
%_sbindir/ipsec
%_sbindir/swanctl
%_libexecdir/%name/pki
%_libexecdir/%name/pt-tls-client
%_man1dir/pt-tls-client.*
%_man5dir/*
%_man8dir/*

%files testing
%pkgdocdir/testing/

%files charon-nm
%_datadir/dbus-1/system.d/nm-strongswan-service.conf
%_libdir/%name/ipsec/charon-nm


# TODO:
# - libstrongswan{,-devel} subpackages
# - review configurables (see also fedora-proposed spec)

%changelog
