Summary: Library for full screen [S]VGA graphics
Summary(de):	Library für Vollbildschirm-[S]VGA-Grafiken
Summary(es):	Biblioteca para gráficos en pantalla llena [S]VGA
Summary(fr):	Une librairie graphique SVGA plein ecran de bas niveau
Summary(pl):	Biblioteki dla pełnoekranowej grafiki [S]VGA
Summary(pt_BR):	Biblioteca para gráficos em tela cheia [S]VGA
Summary(ru_RU):	Низкоуровневая библиотека полноэкранной SVGA графики
Summary(tr):	Tam-ekran [S]VGA çizimleri kitaplýđý
Summary(uk_UA):	Низькорівнева бібліотека повноекранної SVGA графіки
Name: svgalib
Version: 1.9.25
Release: alt2.6
License: distributable
Group: System/Libraries
Source0: %name-%version.tar
Patch0: %name-alt.patch
Patch1: %name-tmp2TMPDIR.patch
Patch2: %name-threeDKit-make.patch
Patch3: %name-1.9.23-unresolved.patch
Patch4: %name-1.9.25-kernel-2.6.26.patch
Patch5: %name-1.9.25-gtf-patch.patch
Patch6: %name-threeDKit-glibc.patch
Patch7: %name-%version-alt-asm-fix.patch
Url: https://www.svgalib.org/
ExclusiveArch: %ix86 x86_64

BuildRequires(pre): rpm-build-kernel

%define _sysconfdir	/etc/vga
%define module_source_dir kernel/svgalib_helper
%define module_name	svgalib_helper

%def_disable static

Packager: L.A.Kostis <lakostis@altlinux.ru>

%description
The svgalib package provides the SVGAlib low-level graphics library
for Linux. SVGAlib is a library which allows applications to use full
screen graphics on a variety of hardware platforms. Many games and
utilities use SVGAlib for their graphics.

%description -l de
SVGAlib ist eine Library, die es Applikationen gestattet, auf einer
Reihe von Plattformen Vollbild-Grafiken zu benutzen. Viele Games und
Utilities nutzen diese Library für den Grafikzugriff, da sie für
Maschinen mit wenig Speicher besser geeignet ist als X-Windows.

%description -l es
SVGAlib es una biblioteca que permite a las aplicaciones usar gráficos
de pantalla llena en una variedad de plataformas de hardware. Muchos
juegos y utilitarios son puestos a disposición para usar la SVGAlib
para acceso a gráficos, pues es más indicado en máquinas con poca
memoria para ejecutar un sistema X Window.

%description -l fr
Le package svgalib apporte la librairie graphique SVGAlib de bas
niveau pour Linux. SVGAlib est une librairie qui permet aux
applications d'utiliser des graphismes en plein écran sur diverses
plateformes matérielles. De nombreux jeux et utilitaires utilisent
SVGAlib pour leurs graphismes.

%description -l pl
Biblioteki dla pełnoekranowej grafiki [S]VGA. Wiele gier i programów
użytkowych korzysta z tych bibliotek, gdyż wymagaj± mniej pamięci niż
X Window System.

%description -l pt_BR
SVGAlib é uma biblioteca que permite a aplicaçőes usar gráficos de
tela cheia em uma variedade de plataformas de hardware. Muitos jogos e
utilitários săo disponibilizados para usar a SVGAlib para acesso a
gráficos, pois ele é mais indicado em máquinas com pouca memória para
rodar um sistema X Window.

%description -l ru_RU
Низкоуровневая графическая библиотека SVGAlib обеспечивает работу с
графическими режимами VGA и SVGA в консоли. SVGAlib позволяет
приложениям использовать полноэкранную графику на разнообразных
аппаратных платформах.

Существует множество игр и утилит, использующих SVGAlib для вывода
графики. Вам необходимо будет установить svgalib, если вы используете
такие программы.

%description -l tr
SVGAlib, deđiţik donaným platformlarý üzerinde, uygulamalarýn tam
ekran çizim kullanmalarýný sađlayan bir kitaplýktýr. Az bellekli
makinalar için X Windows'tan daha uygun olmasýnýn yanýsýra, pek çok
oyun ve yardýmcý programlar çizim eriţimi için bu kitaplýđý kullanýr.

%description -l uk_UA
Низькорівнева графічна бібліотека SVGAlib забезпечує роботу з
графічними режимами VGA та SVGA з консолі. SVGAlib підтримує
повноекранну графіку на різноманітних апаратних платформах.

Існує чимало ігор та утиліт, які використовують SVGAlib для виводу
графіки. Вам необхідно буде встановити svgalib, якщо ви користуєтесь
такими програмами.

%package devel
Summary: Development libraries and include files for [S]VGA graphics
Summary(de):	Entwicklungs-Libraries und INCLUDE-Dateien für (S)VGA-Grafik
Summary(es):	Bibliotecas de desarrollo y archivos de inclusión para gráficos [S]VGA
Summary(fr):	Outils pour développer des programmes utilisant SVGAlib
Summary(pl):	Pliki nagłówkowe i dokumentacja dla [S]VGA
Summary(pt_BR):	Bibliotecas de desenvolvimento e arquivos de inclusăo para gráficos [S]VGA
Summary(ru_RU):	Файлы для разработки программ, использующих SVGAlib
Summary(tr):	[S]VGA grafikleri için geliţtirme kitaplýklarý ve baţlýk dosyalarý
Summary(uk_UA):	Файли для побудови програм, що використовують SVGAlib
Group: Development/C
Requires: %name = %version

%description devel
The svgalib-devel package contains the libraries and header files
needed to build programs which will use the SVGAlib low-level graphics
library.

%description devel -l de
Dies sind die Libraries und Header-Dateien, die zum Erstellen von
Programmen erforderlich sind, die SVGAlib verwenden. Mit SVGAlib
können Programme Vollbildgrafiken auf einer Reihe von Plattformen
verwenden, ohne den von X erforderlichen Overhead.

%description devel -l es
Estas son las bibliotecas y archivos de inclusión que son necesarios
para construir programas que usan SVGAlib. Permite que los programas
usen gráficos de pantalla llena en una variedad de plataformas de
hardware sin el overhead del X.

%description devel -l fr
Le package svgalib-devel contient les librairies et les fichiers
d'entętes nécessaires pour construire des programmes qui utiliseront
la librairie graphique plein écran de bas-niveau SVGAlib.

%description devel -l pl
Pliki nagłówkowe i dokumentacja dla [S]VGA.

%description devel -l pt_BR
Estas săo as bibliotecas e arquivos de inclusăo que săo necessários
para construir programas que usam SVGAlib. SVGAlib permite que
programas usem gráficos de tela cheia em uma variedade de plataformas
de hardware sem o overhead do X.

%description devel -l ru_RU
Это файлы, необходимые для компиляции программ, использующих
библиотеку SVGAlib. SVGAlib позволяет программам использовать
полноэкранную графику на разнообразных аппаратных платформах и без
необходимости запускать для этого X Window.

%description devel -l tr
Bu paket, SVGAlib kitaplýđýný kullanan programlar geliţtirmek için
gereken baţlýk dosyalarýný ve statik kitaplýklarý içerir.

%description devel -l uk_UA
Це файли, необхідні для компіляції програм, що використовують
бібліотеку SVGAlib. SVGAlib дає програмам можливість працювати з
повноекранною графікою на різноманітних апаратних платформах та без
необхідності запускати для цього X Window.

%package devel-static
Summary: Static [S]VGA graphics librarires
Summary(pl):	Biblioteki statyczne [S]VGA
Summary(pt_BR):	Bibliotecas estáticas para desenvolvimento com SVGAlib
Summary(ru_RU):	Статические библиотеки для построения программ, использующих SVGAlib
Summary(uk_UA):	Статичні бібліотеки для побудови програм, що використовують SVGAlib
Group: Development/C
Requires: %name-devel = %version

%description devel-static
Static [S]VGA graphics librarires.

%description devel-static -l pl
Biblioteki statyczne [S]VGA.

%description devel-static -l pt_BR
Bibliotecas estáticas para desenvolvimento com SVGAlib.

%description devel-static -l ru_RU
Это файлы, необходимые для компиляции программ, использующих
библиотеку SVGAlib. SVGAlib позволяет программам использовать
полноэкранную графику на разнообразных аппаратных платформах и без
необходимости запускать для этого X Window.

%description devel-static -l uk_UA
Це файли, необхідні для компіляції програм, що використовують
бібліотеку SVGAlib. SVGAlib дає програмам можливість працювати з
повноекранною графікою на різноманітних апаратних платформах та без
необхідності запускати для цього X Window.

%package utils
Summary: Various utils for using with %name.
Summary(ru_RU): Различные утилиты для %name
Group: System/Configuration/Hardware
Requires: %name = %version-%release

%description utils
Various useful utils for %name.

%description utils -l ru_RU
Различные утилиты для %name, позволяющие управлять видеоустройствами, не
используя X Window.

%package -n kernel-source-%module_name
Summary: %name kernel helper module sources
Summary(ru_RU): kernel-space модуль для %name 
Group: Development/Kernel

%description -n kernel-source-%module_name
%name kernel helper module sources for Linux kernel.

%description -n kernel-source-%module_name -l ru_RU
kernel-space модуль для %name, позволяющий получить низкоуровневый доступ к
видеоустройству не повышая привилегий пользователя.

%prep
%setup -q
%set_verify_elf_method textrel=relaxed
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p2
%patch6 -p2
%patch7 -p2

# remove backup of svgalib.7 - we don't want it in package
rm -f doc/man7/svgalib.7?*

%build
%ifarch %ix86
NOASM=n
%else
NOASM=y
%endif
MOPT="%optflags"

%__mkdir_p sharedlib
ln -sf libvga.so.%version sharedlib/libvga.so
ln -sf libvgagl.so.%version sharedlib/libvgagl.so
%__make CC=%__cc OPTIMIZE="$MOPT" NO_ASM="$NOASM" shared

%__make CC=%__cc LDFLAGS="-L../sharedlib" OPTIMIZE="$MOPT" -C utils
%ifarch %ix86
%__make CC=%__cc CFLAGS="$MOPT" -C lrmi-0.9
%endif
%__make CC="%__cc -L../sharedlib $MOPT" -C threeDKit
%if_enabled static
%__make CC=%__cc OPTIMIZE="$MOPT" NO_ASM="$NOASM" static
%__make CC="%__cc $MOPT" -C threeDKit lib3dkit.a
%endif #static

%install
%__subst 's,\/lib\/,/$(libdir)/,' Makefile
%__make install TOPDIR=%buildroot libdir=%buildroot%_libdir sharedlibdir=%buildroot%_libdir

%if_enabled static
%__make installstaticlib
%__install threeDKit/lib3dkit.a %buildroot%_libdir/
%endif #static
%__mkdir_p %buildroot%_localstatedir/%name

# for separate helper build
%__cp src/vgaversion.h %module_source_dir
%__cp kernel/svgalib_helper/svgalib_helper.h %buildroot%_includedir/
%__subst 's,"../../src/vgaversion.h","vgaversion.h",' %module_source_dir/main.c

%__mkdir_p %kernel_srcdir
%__mv %module_source_dir kernel-source-%module_name-%version
%__tar -c kernel-source-%module_name-%version | bzip2 -c > \
	%buildroot%_usrsrc/kernel/sources/kernel-source-%module_name-%version.tar.bz2

for i in threeDKit/0-*; do %__cp $i $i.threeDKit; done

%files
%doc doc/{CHANGES*,DESIGN,READ*,TODO} threeDKit/*.threeDKit
%dir %_sysconfdir
%config(noreplace) %verify(not size mtime md5) %_sysconfdir/*
%_libdir/lib*.so.*
%_mandir/man[57]/*

%files devel
%doc demos
%_includedir/*.h
%_libdir/lib*.so
%_man3dir/*
%_man6dir/*

%if_enabled static
%files devel-static
%_libdir/lib*.a
%endif #static

%files utils
%_bindir/*
%_mandir/man[18]/*
%dir %_localstatedir/%name

%files -n kernel-source-%module_name
%_usrsrc/kernel

%changelog
