%def_with cmake
%define major 1.8

Name: sword
Version: %major.1
Release: alt5

Summary: The SWORD Project framework for manipulating Bible texts
Summary(ru_RU.UTF-8): Проект SWORD - оболочка для работы с текстами Библии

License: GPL2
Url: http://www.crosswire.org/sword
Group: Databases

Packager: Vitaly Lipatov <lav@altlinux.ru>

#Source0: http://www.crosswire.org/download/ftpmirror.tmp/pub/sword/source/v1.5/%name-%version.tar.bz2
Source: http://www.crosswire.org/ftpmirror/pub/sword/source/v%major/%name-%version.tar
Source2: sword_icons.tar
Patch: https://src.fedoraproject.org/rpms/sword/raw/fddb031c123743bc8dc622d48e65a73727cc398f/f/sword-1.8.1-integer-types.diff

Requires: lib%name = %version

BuildRequires: bc cppunit-devel gcc-c++ glibc-devel libclucene-core-devel libcurl-devel libicu-devel zlib-devel

%if_with cmake
BuildRequires: cmake
%endif

# http://site.icu-project.org/download/61#TOC-Migration-Issues
%add_optflags -DU_USING_ICU_NAMESPACE=1

%description
The SWORD Project is an effort to create an ever expanding software package
for research and study of God and His Word.  The SWORD Framework
allows easy manipulation of Bible texts, commentaries, lexicons, dictionaries,
etc.  Many frontends are build using this framework.  An installed module
set may be shared between any frontend using the framework.

%package -n lib%name
Summary: Main library for sword
Group: System/Libraries

%description -n lib%name
This package contains the library needed to run programs dynamically
linked with sword.

%package -n lib%name-devel
Summary: Include files for developing sword applications
Group: Development/C
Requires: lib%name = %version
Requires: libcurl-devel >= 7.10.5
Requires: zlib-devel

%description -n lib%name-devel
This package contains the headers that programmers
will need to develop applications which will use the SWORD Bible Framework.

%prep
%setup
%patch -p1

%ifarch %e2k
# mcst#4060
%add_optflags -std=gnu++11
# strip UTF-8 BOM for lcc < 1.24
find -name '*.cpp' -o -name '*.h' | xargs sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
%if_with cmake
%cmake -DLIBSWORD_LIBRARY_TYPE=Shared \
       -DSWORD_BUILD_UTILITIES="Yes" \
       -DLIBSWORD_SOVERSION=%{major} \
       -DLIBDIR=%{_libdir} \
       -DSWORD_BUILD_TESTS=Yes
       #-DSWORD_BINDINGS="Python" \
       #-DSWORD_PYTHON_INSTALL_DIR="%{buildroot}%{_prefix}" \

%cmake_build
%else
%add_optflags -fpermissive -ftemplate-depth=100
%autoreconf
%configure --with-lucene --with-icu --with-curl --disable-static
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build
%endif

%install
%if_with cmake
%cmakeinstall_std
%else
%makeinstall_std
pushd utilities
install -m755 mkfastmod mod2vpl vpl2mod %buildroot/%_bindir
popd
%endif

# TODO:
%check
make tests

%files
%_bindir/*
%_sysconfdir/sword.conf
%_datadir/%name/
%doc README AUTHORS NEWS ChangeLog
%doc samples doc/*.*

%files -n lib%name
%_libdir/lib%name.so.%major
#_libdir/%name/

%files -n lib%name-devel
%_includedir/%name/
%_libdir/lib%name.so
%_pkgconfigdir/*.pc

%changelog
