%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%def_enable autotools

Name: synaptic
Version: 0.58
Release: alt29
Summary: Graphical front-end for APT
Summary(ru_RU.UTF-8): Графическая оболочка для APT
Group: System/Configuration/Packaging
# common/rtagcoll{filter,builder}.cc list LGPL-2.1+,
# but that doesn't change the overall license
License: GPL-2.0+
Url: http://www.nongnu.org/synaptic/

# http://people.debian.org/~mvo/synaptic/%name-%version.tar
Source: %name-%version.tar
Source1: package-supported.png
Source2: %name.conf

Patch1: %name-%version-alt.patch

BuildRequires: libapt-devel >= 0.5.15lorg2-alt74
%if_enabled autotools
BuildRequires: intltool
%endif

# From configure.in
BuildRequires: gcc-c++ xmlto librpm-devel libpopt-devel
BuildRequires: libgtk+2-devel >= 2.4.0
BuildRequires: libglade2-devel >= 2.0.0
BuildRequires: libvte-devel >= 0.10.11

BuildRequires: libtinfo-devel scrollkeeper
BuildRequires: gnome-doc-utils

%description
Synaptic is a graphical front-end for APT (Advanced Package Tool).
It attempts to be a lot easier to use than other existing APT front-ends.

Instead of using trees to display packages, Synaptic is heavily based on a
powerful package filtering system. That greatly simplifies the interface
while giving a lot more flexibility to browse through very long package
lists.

%description -l ru_RU.UTF-8
Synaptic - это графическая оболочка для APT (Advanced Package Tool).
Она значительно проще в использовании, чем другие оболочки для APT.

Вместо использования дерева для отображения пакетов synaptic основан
на мощной системе фильтрации пакетов. Это значительно упрощает интерфейс
и вместе с тем предоставляет гораздо больше гибкости при навигации по
очень длинным спискам пакетов.

%prep
%setup
%patch1 -p1

install -p -m644 %SOURCE1 pixmaps/hicolor/16x16/package-supported.png

# bootstrap russian help files
gnome-doc-prepare --copy --force
/usr/bin/xml2po -p po-manual/synaptic-manual.ru.po -o help/ru/synaptic.xml help/C/synaptic.xml

%build
intltoolize --force
%if_enabled autotools
%autoreconf
%endif

%add_optflags -fno-exceptions

%ifnarch %e2k
%add_optflags -std=gnu++17
%else
%add_optflags -std=gnu++14
%endif

# To avoid some errors on API change:
%add_optflags -Werror=overloaded-virtual
# A style enforcement: always use the keyword, which helps to avoid API misuse
%add_optflags -Werror=suggest-override

%configure --with-vte --with-pkg-hold --enable-scripts
%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_mandir/ru/man8/
install -p -m644 man/%name.ru.8 %buildroot%_mandir/ru/man8/%name.8

mkdir -p %buildroot%_sysconfdir/apt/apt.conf.d
install -p -m644 %SOURCE2 %buildroot%_sysconfdir/apt/apt.conf.d/%name.conf

%find_lang --with-gnome %name

%files -f %name.lang
%_sbindir/*
%_datadir/%name
%_man8dir/%name.8.*
%_mandir/ru/man8/%name.8.*
%_iconsdir/hicolor/*/actions/*
%config(noreplace) %_sysconfdir/apt/apt.conf.d/%name.conf
%doc README* TODO NEWS AUTHORS

%exclude %_desktopdir/%{name}*.desktop
%exclude %_datadir/pixmaps/%name.png

%changelog
