%def_without build_docs

Name:    synfigstudio
Version: 1.5.1
Release: alt1

Summary: Synfig studio - animation program
License: GPLv2+
Group:   Office

Url:     http://www.synfig.org
#Source: https://github.com/synfig/synfig.git
Source:  %name-%version.tar
Patch:   synfigstudio-alt-fix-build.patch

# FIXME: crippled zlib-devel (#40274)
ExcludeArch: armh

BuildRequires(pre): rpm-build-xdg
BuildRequires(pre): rpm-build-python3
BuildPreReq: fonts-ttf-liberation
BuildRequires: gcc-c++
BuildRequires: /proc
BuildRequires: ImageMagick-tools
BuildRequires: apt
BuildRequires: boost-devel
BuildRequires: boost-filesystem-devel
BuildRequires: boost-program_options-devel
BuildRequires: fontconfig-devel
BuildRequires: gcc-c++
BuildRequires: git-core
BuildRequires: intltool
BuildRequires: ladspa_sdk
BuildRequires: libImageMagick-devel
BuildRequires: libXcomposite-devel
BuildRequires: libXcursor-devel
BuildRequires: libXdamage-devel
BuildRequires: libXfixes-devel
BuildRequires: libXi-devel
BuildRequires: libXinerama-devel
BuildRequires: libXrandr-devel
BuildRequires: libXt-devel
BuildRequires: libavcodec-devel
BuildRequires: libavformat-devel
BuildRequires: libcairo-devel
BuildRequires: libdirectfb-devel
BuildRequires: libdv-devel
BuildRequires: libfftw3-devel
BuildRequires: libfribidi-devel
BuildRequires: libfreetype-devel
BuildRequires: libgtkmm3-devel
BuildRequires: libjack-devel
BuildRequires: libjasper-devel
BuildRequires: libjpeg-devel
BuildRequires: libltdl7-devel
BuildRequires: libmlt++-devel
BuildRequires: libmng-devel
BuildRequires: libpango-devel
BuildRequires: libpng-devel
BuildRequires: libsigc++2-devel
BuildRequires: libswscale-devel
BuildRequires: libtiff-devel
BuildRequires: libxml++2-devel
BuildRequires: openexr-devel
BuildRequires: zlib-devel
%if_with build_docs
BuildRequires: docbook-style-dsssl-utils
BuildRequires: openjade
#BuildRequires: ldp-docbook-dsssl
%endif

Requires: lib%name = %version-%release

%add_python3_compile_include %_datadir/synfig/plugins

# internal dependency
%add_python3_req_skip common properties.shapePropKeyframe

%description
Synfig Animation Studio is a powerful, industrial-strength vector-based
2D animation software, designed from the ground-up for producing
feature-film quality animation with fewer people and resources.
It is designed to be capable of producing feature-film quality
animation. It eliminates the need for tweening, preventing the
need to hand-draw each frame. Synfig features spatial and temporal
resolution independence (sharp and smoothat any resolution or
framerate), high dynamic range images, and a flexible plugin system.

%package -n lib%name
Summary: Library for Synfig studio
Group: Development/C++
Provides:  libetl = %version-%release
Obsoletes: libetl < %version-%release
Provides:  libsynfig = %version-%release
Obsoletes: libsynfig < %version-%release

%description -n lib%name
Library for Synfig studio.

%package -n lib%name-devel
Summary: Header files for Synfig studio
Group: Development/C++
Requires: lib%name = %version-%release
Provides:  libetl-devel = %version-%release
Obsoletes: libetl-devel < %version-%release
Provides:  libsynfig-devel = %version-%release
Obsoletes: libsynfig-devel < %version-%release

%description -n lib%name-devel
Header files for Synfig studio.

%prep
%setup
%patch -p1
mkdir local-pkg-config
%ifarch %e2k
# -lgcov not there yet...
find -name subs.m4 | xargs sed -i 's, -pg,,;s, -fprofile-arcs,,'
%endif

%build
%add_optflags -fpermissive -std=c++11 -I%_includedir/sigc++-2.0 -I%_libdir/sigc++-2.0/include
export PKG_CONFIG_PATH=../local-pkg-config:$PKG_CONFIG_PATH
%undefine _configure_gettext
%define rpm_synfig_dir %_builddir/%name-%version/synfig-core/src/synfig/.libs

# Build ETL
pushd ETL
%autoreconf
%configure
%make_build
cp ETL.pc ../local-pkg-config
subst 's,^includedir=.*,includedir=%_builddir/%name-%version/ETL,' ../local-pkg-config/ETL.pc
popd

# Build synfig-core
pushd synfig-core
%autoreconf
%configure --with-dv --enable-profiling --enable-profile-arcs
rm libltdl/config-h.in
cp %_datadir/libtool/libltdl/config-h.in libltdl/config-h.in
%make_build
cp synfig.pc ../local-pkg-config
subst 's,^libdir=.*,libdir=%rpm_synfig_dir,;s,^includedir=.*,includedir=%_builddir/%name-%version/synfig-core/src,' ../local-pkg-config/synfig.pc
export PATH=%_builddir/%name-%version/synfig-core/src/tool/.libs:$PATH
export LD_LIBRARY_PATH=%rpm_synfig_dir:$LD_LIBRARY_PATH
mkdir -p $HOME/.local/share/synfig
cp src/modules/synfig_modules.cfg $HOME/.local/share/synfig
cp src/modules/*/.libs/lib*.so %rpm_synfig_dir
popd

# Build main executable
pushd synfig-studio
%autoreconf
%configure
%make_build
popd

%if_with build_docs
# Build docs
pushd synfig-docs
%make_build
popd
%endif

%install
for dir in ETL synfig-core synfig-studio; do
pushd $dir
%makeinstall_std
popd
done

%if_with build_docs
# Install docs
pushd synfig-docs
%makeinstall_std
popd
%endif

# Remove generated mime database
find %buildroot%_xdgmimedir/ -maxdepth 1 -a -type f -delete

# Remove .la files
rm -f %buildroot%_libdir/synfig/modules/*.la

# Add python3 shebang to all python files
subst '/^#!\/usr\/bin\/env python$/d' `find %buildroot -name \*.py`
subst '1i#!%__python3' `find %buildroot -name \*.py`

%find_lang synfig
%find_lang %name
cat synfig.lang >> %name.lang
echo /usr/share/locale/uz@Latn/LC_MESSAGES/synfig.mo >> %name.lang
echo /usr/share/locale/uz@Latn/LC_MESSAGES/synfigstudio.mo >> %name.lang
echo /usr/share/locale/zh-Hant/LC_MESSAGES/synfig.mo >> %name.lang
echo /usr/share/locale/zh-Hant/LC_MESSAGES/synfigstudio.mo >> %name.lang

%files -f %name.lang
%doc synfig-studio/AUTHORS synfig-studio/NEWS synfig-studio/README synfig-studio/TODO
%_bindir/*
%config(noreplace) %_sysconfdir/synfig_modules.cfg
%exclude %_bindir/synfig
%_iconsdir/*/*/*/*.png
%_iconsdir/*/*/*/*.svg
%_desktopdir/*.desktop
%_datadir/synfig/
%_datadir/mime-info/*
%_datadir/appdata/*.appdata.xml
%_xdgmimedir/application/x-sif.xml
%_xdgmimedir/packages/*.xml

%files -n lib%name
%_bindir/synfig
%_libdir/lib*.so.*
%_libdir/synfig/modules

%files -n lib%name-devel
%_libdir/lib*.so
%_includedir/*/*
%_pkgconfigdir/*.pc

%changelog
