# vim: set ft=spec: -*- rpm-spec -*-

%def_enable static

%define _unpackaged_files_terminate_build 1

Name: sysfsutils
Version: 2.1.0
Release: alt8

%define lib_name libsysfs
%define docdir %_docdir/%lib_name-%version

Summary: Utility suite to enjoy sysfs
Group: System/Kernel and hardware
License: GPL
Url: http://linux-diag.sourceforge.net/Sysfsutils.html
Packager: Alexey I. Froloff <raorn@altlinux.org>

Requires: %lib_name = %version-%release

Source: %name-%version.tar
Patch: %name-%version-%release.patch

Source1: sysfs.conf
Source2: sysfs.init
Source3: sysfs.service

%package -n %lib_name
Summary: Main library for %name
License: LGPL
Group: System/Libraries

%package -n %lib_name-devel
Summary: Headers for developing programs that will use %lib_name
License: LGPL
Group: Development/C
Requires: %lib_name = %version-%release

%package -n %lib_name-devel-static
Summary: Static library for developing programs that will use %lib_name
License: LGPL
Group: Development/C
Requires: %lib_name-devel = %version-%release
Obsoletes: %lib_name-static-devel

%description
This package's purpose is to provide a set of utilities for interfacing
with sysfs, a virtual filesystem in Linux kernel versions 2.5+ that
provides a tree of system devices.  While a filesystem is a very useful
interface, we've decided to provide a stable programming interface that
will hopefully make it easier for applications to query system devices
and their attributes.

%description -n %lib_name
This package contains the library needed to run programs dynamically
linked with %lib_name.

%description -n %lib_name-devel
This package contains the headers that programmers will need to develop
applications which will use %lib_name.

%description -n %lib_name-devel-static
This package contains the static library that programmers will need to
develop applications which will use %lib_name.

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	%{subst_enable static}
%make_build

%check
%make_build -k check

%install
mkdir -p %buildroot{/%_lib,%docdir,%_sysconfdir,%_initdir,%_unitdir}

%makeinstall_std

v=`objdump -p %buildroot%_libdir/%lib_name.so |awk '/SONAME/ {print $2}'`
[ -n "$v" ]
mv -v %buildroot%_libdir/%lib_name.so.* %buildroot/%_lib
ln -sf "../../%_lib/$v" %buildroot%_libdir/%lib_name.so

install -p -m644 %_sourcedir/sysfs.conf %buildroot%_sysconfdir/sysfs.conf
install -p -m755 %_sourcedir/sysfs.init %buildroot%_initdir/sysfs
install -p -m644 %_sourcedir/sysfs.service %buildroot%_unitdir/sysfs.service

install -p -m644 AUTHORS CREDITS ChangeLog NEWS TODO docs/*.txt %buildroot%docdir/
bzip2 -9f %buildroot%docdir/{ChangeLog,*.txt}

%post
%post_service sysfs

%preun
%preun_service sysfs

%files
%config(noreplace) %_sysconfdir/sysfs.conf
%_initdir/sysfs
%_unitdir/sysfs.service
%_bindir/*
%_man1dir/*

%files -n %lib_name
/%_lib/%lib_name.so.*
%dir %docdir
%docdir/[A-Z]*

%files -n %lib_name-devel
%_libdir/%lib_name.so
%_includedir/*
%dir %docdir
%docdir/[a-z]*

%if_enabled static
%files -n %lib_name-devel-static
%_libdir/%lib_name.a
%endif

%changelog
