Name: sysvinit
Version: 2.88
Release: alt6

%def_enable selinux
%def_enable initramfs

Summary: Programs which control basic system processes
License: GPLv2+
Group: System/Configuration/Boot and Init
Url: http://savannah.nongnu.org/projects/%name

# ftp://ftp.twaren.net/Unix/NonGNU/%name/%name-%version.tar.bz2
Source: %name-%version.tar

# Debian
Patch11: %name-2.88-deb-doc-manuals.patch
Patch12: %name-2.88-deb-init-keep-utf8-ttyflag.patch
Patch13: %name-2.88-deb-init-selinux.patch

# Owl/ALT
Patch101: %name-2.88-alt-progname.patch
Patch102: %name-2.88-alt-usage.patch
Patch103: %name-2.88-alt-umask.patch
Patch104: %name-2.88-alt-execv-path.patch
Patch105: %name-2.88-rh-alt-owl-pidof.patch
Patch106: %name-2.88-owl-initcmd_setenv.patch
Patch107: %name-2.88-owl-alt-fixes.patch
Patch108: %name-2.88-alt-signedness.patch
Patch109: %name-2.88-alt-makefile.patch
Patch110: %name-2.88-alt-doc.patch
Patch111: %name-2.88-alt-wur.patch
Patch112: %name-2.88-alt-wall-line-size.patch
Patch113: %name-2.88-alt-halt-poweroff.patch
Patch114: %name-2.88-alt-gentoo-kexec.patch
Patch115: %name-2.88-alt-sysmacros.patch

# SuSE
Patch201: %name-2.88-suse-SETSIG.patch

Provides: SysVinit = %version-%release
Obsoletes: SysVinit < %version-%release

Requires: /sbin/sulogin
Requires: %name-utils = %version-%release
Conflicts: glibc < 6:2.2.1-ipl0.2mdk,
BuildConflicts: openssl-devel < 0.9.6a
# Required for SELinux support.
%{?_enable_selinux:BuildRequires: libselinux-devel}

%description
This package contains a group of programs that control the
very basic functions of your system.  sysvinit includes the init
program, the first program started by the Linux kernel when the
system boots.  init then controls the startup, running and shutdown
of all other programs.

%package utils
Summary: Commonly used utilites from sysvinit
Group: System/Base
Conflicts: SysVinit < 2.86-alt2

%description utils
The package contains commonly used non-boot-specific utilities from sysvinit:
bootlogd, killall5, last, lastb, mesg, mountpoint, pidof, pidof, wall.

%if_enabled initramfs
%package initramfs
Summary: Init for initramfs
Group: System/Base

%description initramfs
Simplified version of init (used in initfamfs).
%endif

%prep
%setup

# Debian
%patch11 -p1
%patch12 -p1
%patch13 -p1

# Owl/ALT
%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1
%patch105 -p1
%patch106 -p1
%patch107 -p1
%patch108 -p1
%patch109 -p1
%patch110 -p1
%patch111 -p1
%patch112 -p1
%patch113 -p1
%patch114 -p1
%patch115 -p1

# rest
%patch201 -p1

pushd src
find -type f -print0 |
	xargs -r0 grep -FZl '"paths.h"' -- |
	xargs -r0 sed -i 's/"paths\.h"/"paths_init.h"/g' --
mv paths.h paths_init.h
echo '#include <paths.h>' >>paths_init.h
popd

find -type f -name \*.orig -delete

%build
%if_enabled initramfs
%make_build -C src init \
	DISTRO=ALT \
	CFLAGS='%optflags -fomit-frame-pointer' \
	LDFLAGS= \
	LCRYPT= \
	WITH_SELINUX= \
	#
mv -f src/init{,.initrd}

%make_build -C src clean
%endif

%make_build -C src \
	DISTRO=ALT \
	CFLAGS='%optflags -fomit-frame-pointer' \
	LDFLAGS= \
	LCRYPT= \
	%{?_enable_selinux:WITH_SELINUX=yes} \
	#
%install
mkdir -p %buildroot{/{s,}bin,/dev,%_bindir,%_includedir,%_mandir/man{1,3,5,8}}
%make_install install -C src \
	ROOT=%buildroot \
	DISTRO=ALT \
	#

install -pm755 src/bootlogd src/init.initrd %buildroot/sbin/

mkfifo -m600 %buildroot/dev/initctl

%pre
# This is tricky.  We don't want to let RPM remove the only link to the
# old init as that would actually leave it pending for delete on process
# termination.  That delete is a filesystem write operation meaning that
# the root filesystem would need to stay mounted read/write.  But we
# absolutely want to be able to remount it read-only during shutdown,
# possibly with the old init still alive!
if [ -e /sbin/init -a ! -e /sbin/.init-working ]; then
	ln /sbin/init /sbin/.init-working
fi

%post
# If /proc is mounted and /sbin/.init-working is running, tell init to
# invoke the replaced version of itself.
if pidof /sbin/.init-working >/dev/null 2>&1; then
	/sbin/telinit u
	sleep 1
fi

# If /proc is not mounted or /sbin/.init-working is no longer running,
# remove it.
if ! pidof /sbin/.init-working >/dev/null 2>&1; then
	rm -f /sbin/.init-working
fi

%files
%attr(700,root,root) /sbin/init
%attr(700,root,root) /sbin/shutdown
/sbin/halt
/sbin/fstab-decode
/sbin/poweroff
/sbin/reboot
/sbin/runlevel
/sbin/telinit
%_man5dir/initscript.*
%_man5dir/inittab.*
%_man8dir/halt.*
%_man8dir/fstab-decode.*
%_man8dir/init.*
%_man8dir/poweroff.*
%_man8dir/reboot.*
%_man8dir/runlevel.*
%_man8dir/shutdown.*
%_man8dir/telinit.*
%_includedir/*
%ghost /dev/initctl

%if_enabled initramfs
%files initramfs
%attr(700,root,root) /sbin/init.initrd
%endif

%files utils
%attr(700,root,root) /sbin/bootlogd
/sbin/killall5
/sbin/pidof
/bin/mountpoint
/bin/pidof
%_bindir/last
%_bindir/lastb
%_bindir/mesg
%attr(2711,root,tty) %_bindir/wall
%_man1dir/last.*
%_man1dir/lastb.*
%_man1dir/mesg.*
%_man1dir/mountpoint.*
%_man1dir/wall.*
%_man8dir/bootlogd.*
%_man8dir/killall5.*
%_man8dir/pidof.*

%changelog
