%define teaname tclxml

Name: tcl-xml
Version: 3.2
Release: alt2

Summary: XML parsers for Tcl
License: BSD
Group: Development/Tcl
Url: http://tclxml.sourceforge.net/

# repacked http://prdownloads.sourceforge.net/tclxml/tclxml-%version.tar.gz
Source: %teaname-%version.tar
Patch1: 0001-reverted-fix-for-sf-bug-596959-seems-unneeded.patch
Patch2: 0002-ALT-TEA.patch
Patch3: 0003-FEDORA-sgmlparser.patch
Patch4: 0004-FEDORA-xmlGenericError.patch

BuildRequires: rpm-build-tcl >= 0.2-alt1
BuildRequires: libxml2-devel rpm-build >= 4.0.4-alt41 tcl-devel >= 8.4.0-alt1
BuildRequires: libxslt-devel
BuildRequires: /usr/bin/xslt-config
BuildRequires: tcllib

Provides: tcl-xml-core tcl-dom-core tcl-xslt
Obsoletes: tcl-xml-core < 3.2
Obsoletes: tcl-dom-core < 3.2
Obsoletes: tcl-xslt < 3.2
Conflicts: tcl-xml-libxml2 < 3.2
Conflicts: tcl-dom-libxml2 < 3.2

%package devel
Summary: Header files for %name
Group: Development/Tcl
Requires: %name

%description
This package provides XML parsers for Tcl scripts.  There is a generic
front-end interface with plugin parser implementations.  A number of parser
implementations or wrappers are provided:
* James Clark's expat library.  This package is known as TclXML/expat.
* Gnome libxml2 library.  This package is known as TclXML/libxml2.
* A generic Tcl implementation, known as TclXML/tcl.

%description devel
This package includes header files for %name.

%prep
%setup -n %teaname-%version
%autopatch -p2

%build
%autoreconf
%configure \
	--disable-static \
	--enable-stub \
	#
%make_build
# build doc
cp -a tclxml-tcl/* .
make doc

%install
%make_install DESTDIR=%buildroot install install-doc
xz ChangeLog

%files
%doc ANNOUNCE ChangeLog* README.html LICENSE
%doc doc/*.html
%_tcllibdir/Tclxml%version/libTclxml%version.so
%_tcllibdir/Tclxml%version/*.tcl
%_mandir/mann/*

%files devel
%_includedir/tclxml
%_tcllibdir/Tclxml%version/libTclxmlstub%version.a

%changelog
