# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%define _localstatedir /var

%def_with monitor

Name: thermald
Version: 2.5.3
Release: alt0.p10

Summary: Thermal daemon for IA

License: GPL-3.0-or-later
Group: System/Kernel and hardware

Url: https://github.com/intel/thermal_daemon
# Git: https://github.com/intel/thermal_daemon.git

Source: %name-%version.tar
Source1: thermald.init
Source2: %name-monitor.svg

Patch1: thermald-2.4.6-alt-ui-cosmetic-fixes-to-avoid-label-cut-in-dialogs.patch

ExclusiveArch: x86_64

BuildRequires: gcc-c++ libgomp-devel
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: libdbus-glib-devel
BuildRequires: systemd-devel
BuildRequires: gtk-doc
BuildRequires: liblzma-devel
BuildRequires: libupower-devel
BuildRequires: libevdev-devel
BuildRequires: autoconf-archive
Requires: dbus

%description
Thermal issues are important to handle proactively to reduce performance impact.

The project provides a Linux user mode daemon to system developers, reducing
time to market with controlled thermal management using P-states, T-states, and
the Intel power clamp driver. The Thermal Daemon uses the existing Linux kernel
infrastructure and can be easily enhanced.

%description -l ru_RU.UTF-8
thermald представляет собой службу, которая управляет питанием с помощью
Р-состояний, Т-состояния и Intel power clamp driver. thermald использует
существующую инфраструктуру ядра Linux, и его возможности могут быть легко
расширены.

%if_with monitor
%package monitor
Summary: Application for monitoring %name
License: GPLv3+
Group: Monitoring
BuildRequires: qt5-base-devel
BuildRequires: qcustomplot-qt5-devel
Requires: %name

%description monitor
This package contains an Application to monitor %name for system
developers who want to enable application developers and their
customers with the responsive and flexible thermal management,
supporting optimal performance in desktop, clam-shell, mobile and
embedded devices.
%endif

%prep
%setup
#patch1 -p2

sed -i 's/LIBS += -lqcustomplot/LIBS += -lqcustomplot-qt5/' \
  tools/thermal_monitor/ThermalMonitor.pro

%build
./autogen.sh
%configure \
    --disable-option-checking \
    --disable-silent-rules
%make_build

%if_with monitor
# Build the monitor-app.
pushd tools/thermal_monitor
mkdir -p %_target_platform
pushd %_target_platform
%qmake_qt5 ..
%make_build
popd
popd
%endif

%install
%makeinstall_std
install -pD -m644 data/%name.service \
    %buildroot%_unitdir/%name.service
install -pD -m755 %SOURCE1 %buildroot%_initdir/%name

# Install management-script
install -Dpm 0755 tools/thermald_set_pref.sh \
    %buildroot%_bindir/%name-set-pref

# DBus config belongs into %%_datadir
mkdir -p %buildroot%_datadir/dbus-1
mv -f %buildroot%_sysconfdir/dbus-1/* %buildroot%_datadir/dbus-1/

# Install tmpfiles.d
mkdir -p alt_addons
cat << EOF > alt_addons/%name.conf
d /run/%name 0755 root root -
EOF

install -Dpm 0644 alt_addons/%name.conf \
    %buildroot%_tmpfilesdir/%name.conf

# Install config
install -Dpm 0644 data/thermal-conf.xml \
    %buildroot%_sysconfdir/%name/thermal-conf.xml

%if_with monitor
# Create desktop-file for the monitor-app
cat << EOF > alt_addons/%name-monitor.desktop
[Desktop Entry]
Name=%name Monitor
Comment=Application for monitoring %name
Icon=%name-monitor
Categories=System;Settings;
Exec=%_bindir/ThermalMonitor
Type=Application
StartupNotify=true
Terminal=false
EOF

# Install the monitor-app
install -Dpm 0755 tools/thermal_monitor/%_target_platform/ThermalMonitor \
    %buildroot%_bindir/ThermalMonitor
install -Dpm 0644 alt_addons/%name-monitor.desktop \
    %buildroot%_desktopdir/%name-monitor.desktop
install -Dpm 0644 %SOURCE2 \
    %buildroot%_iconsdir/hicolor/scalable/apps/%name-monitor.svg

# Create ReadMe.txt for the monitor-app
cat << EOF > alt_addons/ReadMe
Running the thermald-monitor-app
--------------------------------

To communicate with thermald via dbus, the user has to be member
of the "power" group. So make sure to add your user id to this
group before using the thermald-monitor-app.
EOF

%endif

%pre
%_bindir/getent group power >/dev/null || %_sbindir/groupadd -r power
exit 0

%post
%post_service thermald

%preun
%preun_service thermald

%files
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/thermal-conf.xml
%config(noreplace) %_sysconfdir/%name/thermal-cpu-cdev-order.xml
%doc README.txt thermal_daemon_usage.txt COPYING
%_tmpfilesdir/%name.conf
%_sbindir/%name
%_bindir/%name-set-pref
%_datadir/dbus-1/system-services/org.freedesktop.%name.service
%_datadir/dbus-1/system.d/org.freedesktop.%name.conf
%_unitdir/%name.service
%_initdir/%name
%_man5dir/*
%_man8dir/*

%if_with monitor
%files monitor
%doc alt_addons/ReadMe
%_bindir/ThermalMonitor
%_desktopdir/%name-monitor.desktop
%_iconsdir/hicolor/scalable/apps/%name-monitor.svg
%endif

%changelog
