Name: tkabber
Version: 1.1.2
Release: alt1

Summary: Tkabber is an open source Jabber Client.
License: GPL
Group: Networking/Instant messaging
Url: http://tkabber.jabber.ru/

BuildArch: noarch
BuildRequires(pre): rpm-build-tcl >= 0.2.1-alt2
BuildRequires: cpio tcl tcllib

Requires: tcl-gpg tcl-udp tcl-tktray tcl-xmpp = %EVR
Conflicts: tkabber-plugins < 0.11.1-alt2

# http://git.altlinux.org/gears/t/tkabber.git
Source0: %name-%version-%release.tar
Source1: %name.watch

%description
Tkabber provides a Tcl/Tk interface to the Jabber instant messaging
and presence service.
Wtiting in Tcl/Tk, used TclLib and BWidget, working on Linux, FreeBSD,
NetBSD, Solaris and Windows 98/2000/XP.

%package -n tcl-xmpp
Summary: XMPP library for Tcl
BuildArch: noarch
License: BSD
Group: Development/Tcl

%description -n tcl-xmpp
This project implements an XMPP (RFC-3920 and RFC-3921) library
which is to be used for clients, bots and components written in Tcl.

%prep
%setup
sed -i 's,@version@,%version-%release,' tkabber.tcl

%build
dtplite -o . -ext n nroff tclxmpp/doc

%install
mkdir -p %buildroot%_bindir %buildroot%_datadir/%name
cat > %buildroot%_bindir/%name << EOF
#!/bin/sh
#\\
exec wish "\$0" -name %name "\$@"
set ::env(TKABBER_SITE_PLUGINS) %_datadir/%name-plugins
source %_datadir/%name/%name.tcl

EOF
chmod +x %buildroot%_bindir/%name

(cd altlinux && find . -type f |cpio -pmd %buildroot%_datadir)
find . -type f -not '(' -name \*..\* \
    -o -name tkabber.spec \
    -o -regex \./\\..\+ \
    -o -regex \./altlinux/.\+ \
    -o -regex \./\[A-Z\]\[^/\.\]\+ \
    -o -regex \./doc/.\+ \
    -o -regex \./contrib/.\+ \
    -o -regex \./tclxmpp/.\+ \
    -o -regex \./examples/.\+ ')' | cpio -pmd %buildroot%_datadir/%name

gzip -9nf ChangeLog

# tcl-xmpp
mkdir -p %buildroot%_tcldatadir/xmpp
cp -a tclxmpp/xmpp %buildroot%_tcldatadir

mkdir -p %buildroot%_mandir/mann
install -pm0644 files/*.n %buildroot%_mandir/mann

gzip -9nf tclxmpp/ChangeLog

%files
%doc INSTALL ChangeLog.* COPYING README doc/* contrib examples 
%_bindir/%name
%_datadir/%name
%_liconsdir/*
%_miconsdir/*
%_niconsdir/*
%_desktopdir/%name.desktop

%files -n tcl-xmpp
%doc tclxmpp/ChangeLog* tclxmpp/examples tclxmpp/license.terms
%_tcldatadir/xmpp
%_mandir/mann/xmpp*

%changelog
