%ifarch x86_64
%define cpro_arch amd64
%else
%define cpro_arch ia32
%endif

%define rev c6ec8f5

Name:    token-manager
Version: 0.12
Release: alt10

Summary: Certificate manager for CryptoPro CSP
License: MIT
Group:   Security/Networking
URL:     https://github.com/bmakarenko/token-manager

Packager: Andrey Cherepanov <cas@altlinux.org>
BuildArch: noarch

Source: %name.tar
Source1: cpconfig-pam.alt
Source2: token-manager

Patch0: token-manager-port-to-python3-and-PyQt5.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: libpam-devel
BuildRequires: python3-module-PyQt5

Requires: consolehelper opensc

%description
A PyQt front-end for Crypto Pro CSP for CentOS 6 and GosLinux by The
Federal Bailiffs' Service of Russia.

%prep
%setup -q
%patch0 -p1
subst 's|python|python3|' %name.desktop

%install
mkdir -p %buildroot/%_bindir
ln -s %_libexecdir/consolehelper/helper %buildroot%_bindir/cpconfig-%cpro_arch
install -Dm 0644 %name.py %buildroot%_bindir/%name.py
install -Dm 0644 %name.png %buildroot%_pixmapsdir/%name.png
install -Dm 0644 %name.desktop %buildroot%_desktopdir/%name.desktop
install -Dm 0644 %SOURCE1 %buildroot%_sysconfdir/pam.d/cpconfig-%cpro_arch
install -Dm 0755 %SOURCE2 %buildroot%_bindir/%name
install -Dm 0644 cpconfig-%cpro_arch %buildroot%_sysconfdir/security/console.apps/cpconfig-%cpro_arch

%files
%_bindir/*
%_pixmapsdir/%name.png
%_desktopdir/%name.desktop
%config(noreplace) %_sysconfdir/pam.d/cpconfig-%cpro_arch
%config(noreplace) %_sysconfdir/security/console.apps/cpconfig-%cpro_arch

%changelog
