%def_disable snapshot
%define ver_major 2.3
%define api_ver 2.0
%define gst_api_ver 1.0

# since 1.0.3 (see https://bugzilla.gnome.org/show_bug.cgi?id=733857)
%set_verify_elf_method unresolved=relaxed

%def_without bootstrap
%def_enable introspection
%def_enable upower
%def_enable network_manager
%def_enable stemmer
%def_disable docs
%def_enable functional_tests
%def_disable autostart

# Unicode support library? (unistring|icu)
%define unicode_support icu

%define _libexecdir %_prefix/libexec

Name: tracker
Version: %ver_major.6
Release: alt1

Summary: Tracker is a powerfull desktop-oriented search tool and indexer
License: GPLv2+
Group: Office
Url: http://wiki.gnome.org/Projects/Tracker

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Obsoletes: lib%name-client
Obsoletes: %name-search-tool < 1.99.0
Obsoletes: nautilus-%name < 1.99.0

Requires: lib%name = %version-%release
%{?_without_bootstrap:Requires: %name-miners >= %ver_major}

%define dbus_ver 1.3.1
%define glib_ver 2.44.0
%define pango_ver 1.0.0
%define gtk_ver 3.0.0
%define upower_ver 0.9.0
%define gst_ver 1.0
%define sqlite_ver 3.20.1-alt2
%define soup_ver 2.40.0
%define gupnp_dlna_ver 0.9.4

Requires: libsqlite3 >= %sqlite_ver

BuildRequires(pre): meson rpm-build-gnome rpm-build-gir
%{?_enable_functional_tests:
BuildRequires(pre): rpm-build-python3
%add_python3_path %_libdir/%name-%api_ver/trackertestutils
}
BuildRequires: gcc-c++ gnome-common
BuildRequires: gtk-doc docbook-utils python3
BuildRequires: libxml2-devel libicu-devel libuuid-devel
BuildRequires: libdbus-devel >= %dbus_ver
BuildRequires: libgio-devel >= %glib_ver libpango-devel >= %pango_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libsoup-devel >= %soup_ver libjson-glib-devel
BuildRequires: gobject-introspection-devel
%{?_enable_upower:BuildRequires: libupower-devel >= %upower_ver}
%{?_enable_network_manager:BuildRequires: libnm-devel}
%{?_enable_stemmer:BuildRequires: libstemmer-devel}
BuildRequires: vala-tools
BuildRequires: sqlite3 libsqlite3-devel >= %sqlite_ver
BuildRequires: gstreamer%gst_api_ver-devel >= %gst_ver gst-plugins%gst_api_ver-devel >= %gst_ver
BuildRequires: libgupnp-dlna-devel >= %gupnp_dlna_ver
BuildRequires: pkgconfig(systemd) libseccomp-devel

%description
Tracker is a powerful desktop-neutral first class object
database, tag/metadata database, search tool and indexer.

%package devel
Summary: Headers for developing programs that will use %name-miner
Group: Development/Other
Requires: lib%name = %version-%release
Requires: %name = %version-%release
Obsoletes: lib%name-client-devel
License: LGPLv2.1+

%description devel
Tracker is a powerfull desktop-oriented search tool and indexer.
This package contains header files for development  and link applications with libtracker-miner.

%package devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
This package provides development documentation for %name.

%package -n lib%name
Summary: Tracker shared libraries
Group: System/Libraries
Conflicts: %name < %version-%release

%description -n lib%name
This package contains shred Tracker libraries for applications.

%package -n lib%name-gir
Summary: GObject introspection data for the Tracker library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the Tracker library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Tracker library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Provides: gir(Tracker) = 2.0

%description -n lib%name-gir-devel
GObject introspection devel data for the Tracker library

%package search-tool
Summary: Tracker search tool(s)
Group: Graphical desktop/GNOME
Requires: %name = %version-%release

%description search-tool
Graphical frontend to tracker search facilities.

%package utils
Summary: Commandline tools for Tracker
Group: Office
Requires: %name = %version-%release

%description utils
Included utilities for Tracker:
  * tracker-import: imports turtle file data into the database.
  * tracker-info: retrieve all information available for a certain file.
  * tracker-control: manage Tracker processes and data.
  * tracker-search: this perfoms a google like search using SEARCHTERM to
    retrieve all matching files where SEARCHTERM appears in any searchable
    metadata.
  * tracker-stats: retreive some statistics.
  * tracker-sparql: allows  the caller to run an RDF query on the database.
  * tracker-tag: tool to manage tags on files.

%package tests
Summary: Tests for Tracker search tool
Group: Development/Other
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Tracker.

%prep
%setup
#fixed install_rpath for tracker, tracker-store binaries
sed -i 's/tracker_install_rpath/tracker_internal_libs_dir/' src/tracker*/meson.build

%build
%meson \
	-Dunicode_support=%unicode_support \
	%{?_enable_network_manager:-Dnetwork_manager=enabled} \
	%{?_enable_stemmer:-Dstemmer=enabled} \
	%{?_enable_docs:-Ddocs=true} \
	%{?_disable_functional_tests:-Dfunctional_tests=false}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%files -f %name.lang
%doc AUTHORS COPYING NEWS README*
%doc src/libtracker-common/COPYING.LIB
%{?_enable_autostart:%config(noreplace) %_sysconfdir/xdg/autostart/*}
%_datadir/glib-2.0/schemas/*
%dir %_libdir/%name-%api_ver
%_libexecdir/tracker-store
%_datadir/dbus-1/services/*.service
%dir %_datadir/%name
%_datadir/%name/*.xml
%_datadir/%name/stop-words/
%_datadir/%name/ontologies/
%_datadir/%name/domain-ontologies/
%_prefix/lib/systemd/user/tracker-store.service
%_man1dir/tracker-store.*

%exclude %_datadir/bash-completion/completions/%name

%files -n lib%name
%_libdir/*.so.*
%_libdir/%name-%api_ver/*.so

%files utils
%_bindir/%name
%_man1dir/tracker-info.*
%_man1dir/tracker-search.*
%_man1dir/tracker-sparql.*
%_man1dir/tracker-tag.*
%_man1dir/tracker-daemon.*
%_man1dir/tracker-index.*
%_man1dir/tracker-reset.*
%_man1dir/tracker-sql.*
%_man1dir/tracker-status.*
%_man1dir/tracker-export.*

%files devel
%_includedir/%name-%api_ver/
%_pkgconfigdir/*.pc
%_libdir/*.so
%_vapidir/*

%if_enabled docs
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/Tracker-%api_ver.typelib
%_typelibdir/TrackerControl-%api_ver.typelib
%_typelibdir/TrackerMiner-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Tracker-%api_ver.gir
%_girdir/TrackerControl-%api_ver.gir
%_girdir/TrackerMiner-%api_ver.gir
%endif

%if_enabled functional_tests
%files tests
%_libdir/%name-%api_ver/trackertestutils/
%endif

%changelog
