Name: upmpdcli
Version: 1.4.14
Release: alt2

Summary: UPnP front-end to the Music Player Daemon
License: LGPLv2.1
Group: Sound
Url: http://www.lesbonscomptes.com/upmpdcli

Source: %name-%version-%release.tar

BuildRequires: gcc-c++ libmpdclient-devel libupnpp-devel >= 0.14.1
BuildRequires: libmicrohttpd-devel jsoncpp-devel rpm-build-python3

%package plugins
Summary: %name plugins
Group: Sound
Requires: %name = %version-%release
BuildArch: noarch

%description
%name implements an UPnP Media Renderer, using MPD to perform
the real work.

It has been tested with a number of UPnP control points running on
Android and Windows. Because of their good support of OpenHome
Playlists, which are a significant improvement over bare UPnP,
and their general quality, Bubble UPnP (Android app) and Linn Kinsky
(free on Windows) work best with it.

%description plugins
%name implements an UPnP Media Renderer, using MPD to perform
the real work.

It has been tested with a number of UPnP control points running on
Android and Windows. Because of their good support of OpenHome
Playlists, which are a significant improvement over bare UPnP,
and their general quality, Bubble UPnP (Android app) and Linn Kinsky
(free on Windows) work best with it.

This package contains various plugins, mostly for use with
popular streaming services like Google Music

%prep
%setup

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std
install -pm0755 -D upmpdcli.init %buildroot%_initdir/upmpdcli
install -pm0644 -D upmpdcli.sysconfig %buildroot%_sysconfdir/sysconfig/upmpdcli
install -pm0644 -D upmpdcli.service %buildroot%_unitdir/upmpdcli.service
mkdir -p %buildroot%_cachedir/%name
# next time for sure
rm -rf %buildroot%_datadir/%name/web

%pre
/usr/sbin/groupadd -r -f _upmpd &>/dev/null ||:
/usr/sbin/useradd -r -g _upmpd -d %_cachedir/%name -s /dev/null \
    -c "upmpdcli service" -M -n _upmpd &>/dev/null ||:

%post
%post_service upmpdcli

%preun
%preun_service upmpdcli

%set_python3_req_method strict

# self-contained:
%add_python3_req_skip StreamDecoder
%add_python3_req_skip cmdtalkplugin
%add_python3_req_skip conftree routing session
%add_python3_req_skip tidalapi tidalapi.models
%add_python3_req_skip upmplgutils
%add_python3_req_skip uprclindex uprclinit uprclsearch uprclutils
# conditional(py2):
%add_python3_req_skip ConfigParser
%add_python3_req_skip Cookie
%add_python3_req_skip StringIO
%add_python3_req_skip cPickle
%add_python3_req_skip httplib
%add_python3_req_skip thread
%add_python3_req_skip urlparse
# runtime alternatives:
%add_python3_req_skip aiohttp.wsgi
%add_python3_req_skip diesel.protocols.wsgi
%add_python3_req_skip fapws
%add_python3_req_skip fapws._evwsgi
%add_python3_req_skip google.appengine.ext.webapp
%add_python3_req_skip rocket
%add_python3_req_skip uvloop

%files
%config(noreplace) %attr(0640,root,_upmpd) %_sysconfdir/%name.conf
%config(noreplace) %_sysconfdir/sysconfig/upmpdcli

%_initdir/upmpdcli
%_unitdir/upmpdcli.service

%_bindir/scctl
%_bindir/upmpdcli

%_datadir/%name
%exclude %_datadir/%name/Analog-Input
%exclude %_datadir/%name/cdplugins
%exclude %_datadir/%name/radio_scripts
%exclude %_datadir/%name/rdpl2stream
%exclude %_datadir/%name/src_scripts
%_man1dir/%name.1*

%dir %attr(0770,root,_upmpd) %_cachedir/%name

%files plugins
%_datadir/%name/Analog-Input
%_datadir/%name/cdplugins
%_datadir/%name/radio_scripts
%_datadir/%name/rdpl2stream
%_datadir/%name/src_scripts

%changelog
