%define _unpackaged_files_terminate_build 1

Name: usrmerge
Version: 0.7
Release: alt1

Summary: transition to merged usr

URL: https://altlinux.org/Usrmerge
License: MIT
Group: Other

Source: usrmerge-%version.tar

BuildRequires: make
BuildRequires: gcc

# Pull in all subpackages.
Requires: %name-hier-convert = %EVR

%description
A toolset to merge /bin, /sbin, /lib, /%_lib with their counterparts
under /usr, as safely as possible.

%prep
%setup

%build
CFLAGS="${CFLAGS:-%optflags}"; export CFLAGS;
./configure
%make_build -C out

%install
%make_install install -C out DESTDIR=%buildroot

%files
%dir %_prefix/libexec/usrmerge
%_prefix/libexec/usrmerge/mv-xchg
%_prefix/libexec/usrmerge/realpath-1

# Unfortunately, we cannot make the base package noarch and put arch-specific
# tools in a subpackage; we have to do quite the opposite.
%package hier-convert
Summary: Hierarchy conversion script
Group: System/Base
BuildArch: noarch
AutoReq: no
Requires: bash
Requires: coreutils
Requires: findutils
# Require cmp(1).
Requires: diffutils
# Require file(1) which supports file -p.
Requires: file
Requires: usrmerge = %EVR

%description hier-convert
A script which merges /bin, /sbin, /lib, /lib%_lib with their counterparts
under /usr, as safely as possible.

This package contains the script which converts the hierarchy layout.
It is intended to be called from a filetrigger or in rpm pretrans stage, but
can be invoked directly by an administrator who knows what they are doing.

%files hier-convert
%_prefix/libexec/usrmerge/hier-convert

##package block
#Summary: Install this to block installation of filesystem >= 3
#Group: Other
#BuildArch: noarch
#AutoReq: no
#Conflicts: filesystem >= 3
#
##description block
#This metapackage contains nothing. Its purpose is to keep the filesystem
#package in a system compatible with unmerged-usr, if this is temporarily
#desired on some machine.
#
##files block
#
%package ensure
Summary: Install this to convert to merged-usr
Group: Other
BuildArch: noarch
AutoReq: no
Requires(pre): usrmerge-hier-convert
# We want /proc access so usrmerge-ensure passes install check;
# its %%pre script runs hier-convert.
Requires(pre): /proc

%description ensure
This metapackage contains nothing. Its purpose is to automatically enforce the
migration to merged-usr when installed.

%files ensure

%pre ensure -p <lua>
hier_convert_prog = "%_prefix/libexec/usrmerge/hier-convert"
-- Ensure log messages are line-buffered.
os.execute("printf '%%s\n' '%name-ensure-%EVR: Starting usrmerge-hier-convert...'")
assert(os.execute(hier_convert_prog))

%changelog
