%define _pseudouser_user     _uwsgi
%define _pseudouser_group    _uwsgi
%define _pseudouser_home     /var/empty

Name: uwsgi
Version: 2.0.23
Release: alt1

Summary: fast (pure C), self-healing, developer-friendly WSGI server
License: GPLv2
Group: System/Servers

Url: http://projects.unbit.it/uwsgi/

Source: %name-%version.tar
Source1: %name.init
Source2: %name.logrotate
Source3: %name.sysconfig
Patch1: %name-2.0.15-alt-no-rpath.patch
Patch2000: %name-e2k.patch

BuildRequires: libxml2-devel python3-devel

%description
uWSGI is a fast (pure C), self-healing, developer-friendly WSGI server,
aimed for professional python webapps deployment and development. Over
time it has evolved in a complete stack for networked/clustered python
applications, implementing message/object passing, RPC and process
management. It uses the uwsgi (all lowercase) protocol for all the
networking/interprocess communications. From the 0.9.5 release it
includes a plugin loading technology that can be used to add support for
other languages or platform. A Lua wsapi adaptor, a PSGI handler and an
Erlang message exchanger are already available.

%pre
/usr/sbin/groupadd -r -f %_pseudouser_group ||:
/usr/sbin/useradd -g %_pseudouser_group -c 'The uwsgi daemon' \
	-d %_pseudouser_home -s /dev/null -r %_pseudouser_user >/dev/null 2>&1 ||:

%prep
%setup
%patch1 -p1
%ifarch %e2k
%patch2000 -p1
%endif

%build
%make

%install
install -dm0775 %buildroot%_logdir/%name

install -pDm0755 %name %buildroot%_bindir/%name
install -pDm0755 %SOURCE1 %buildroot%_initdir/%name
install -pDm0644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/%name
install -pDm0644 %SOURCE2 %buildroot%_sysconfdir/logrotate.d/%name

%post
%post_service %name

%preun
%preun_service %name

%files
%_bindir/%name
%dir %attr(0775,root,%_pseudouser_group) %_logdir/%name
%config %_initdir/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%config(noreplace) %_sysconfdir/logrotate.d/%name
%doc README contrib

%changelog
