Name: vsftpd
Version: 3.0.3
Release: alt2

Summary: File Transfer Protocol (FTP) server
License: GPLv2
Group: System/Servers
Url: https://security.appspot.com/vsftpd.html

# https://security.appspot.com/downloads/%name-%version.tar.gz
Source: %name-%version.tar
Source1: vsftpd.xinetd
Source2: vsftpd.pamd
Source3: vsftpd.logrotate
Source4: vsftpd.banner_fail
# The dia source to vsftpd.eps is available through the download link
# from http://www.openwall.com/presentations/Owl/
Source5: vsftpd.eps
Source6: vsftpd.socket
Source7: vsftpd@.service

Patch: vsftpd-%version-%release.patch

Requires: /var/empty
Provides: ftpserver

# Automatically added by buildreq on Mon Dec 17 2001
BuildRequires: libcap-devel libpam-devel pam_userpass-devel

%description
vsftpd is a File Transfer Protocol (FTP) server.  The "vs" stands for
Very Secure.  Obviously this is not a guarantee, but a reflection that
the entire codebase has been written with security in mind, and the
program has been carefully designed to be resilient to attack.

%prep
%setup
%patch -p1
install -p -m644 %_sourcedir/vsftpd.eps .
bzip2 -9k Changelog
bzip2 -9 vsftpd.eps

%build
%make_build \
	CFLAGS='%optflags -fPIE -Wall -W -Wshadow -Werror' \
	LIBS='-lcap -lpam -lpam_userpass' LINK=

%install
install -pD -m755 vsftpd %buildroot%_sbindir/vsftpd
mkdir -p %buildroot%_sysconfdir/vsftpd/user_conf
install -pD -m600 vsftpd.conf %buildroot%_sysconfdir/vsftpd/conf
ln -s vsftpd/conf %buildroot%_sysconfdir/vsftpd.conf
for f in %buildroot{%_sysconfdir/vsftpd/{banned_emails,chroot_list,user_list},%_logdir/vsftpd.log}; do
	install -pD -m600 /dev/null "$f"
done

install -pD -m640 %_sourcedir/vsftpd.xinetd \
	%buildroot%_sysconfdir/xinetd.d/vsftpd
install -pD -m640 %_sourcedir/vsftpd.pamd \
	%buildroot%_sysconfdir/pam.d/vsftpd
install -pD -m640 %_sourcedir/vsftpd.logrotate \
	%buildroot%_sysconfdir/logrotate.d/vsftpd
install -pD -m600 %_sourcedir/vsftpd.banner_fail \
	%buildroot%_sysconfdir/vsftpd/banner_fail

install -pD -m644 %_sourcedir/vsftpd@.service \
	%buildroot%systemd_unitdir/vsftpd@.service
install -pD -m644 %_sourcedir/vsftpd.socket \
	%buildroot%systemd_unitdir/vsftpd.socket

install -pD -m644 vsftpd.conf.5 %buildroot%_man5dir/vsftpd.conf.5
install -pD -m644 vsftpd.8 %buildroot%_man8dir/vsftpd.8

%post
umask 077
/usr/sbin/groupadd -r -f vsftpd
/usr/sbin/groupadd -r -f novsftpd
/usr/sbin/useradd -r -g vsftpd -d /var/ftp -s /dev/null -n vsftpd >/dev/null 2>&1 ||:
/usr/sbin/useradd -r -g novsftpd -d /dev/null -s /dev/null -n novsftpd >/dev/null 2>&1 ||:
touch %_logdir/vsftpd.log

%files
%_sbindir/vsftpd
%_sysconfdir/vsftpd.conf
%attr(700,root,root) %dir %_sysconfdir/vsftpd
%attr(700,root,root) %dir %_sysconfdir/vsftpd/user_conf
%config(noreplace,missingok) %ghost %_sysconfdir/vsftpd/banned_emails
%config(noreplace,missingok) %ghost %_sysconfdir/vsftpd/chroot_list
%config(noreplace,missingok) %ghost %_sysconfdir/vsftpd/user_list
%config(noreplace) %_sysconfdir/vsftpd/banner_fail
%config(noreplace) %_sysconfdir/vsftpd/conf
%config(noreplace) %_sysconfdir/xinetd.d/vsftpd
%config(noreplace) %_sysconfdir/pam.d/vsftpd
%config(noreplace) %_sysconfdir/logrotate.d/vsftpd
%systemd_unitdir/vsftpd@.service
%systemd_unitdir/vsftpd.socket
%ghost %_logdir/vsftpd.log
%_mandir/man?/*
%doc AUDIT BENCHMARKS BUGS Changelog.bz2 EXAMPLE FAQ LICENSE
%doc README README.security REWARD SECURITY SIZE SPEED TODO TUNING
%doc vsftpd.eps.bz2

%changelog
