%define _vklib amdvlk
%define _vkdir %_datadir/vulkan/icd.d
# Decrease debuginfo verbosity to reduce memory consumption during final library linking
%define optflags_debug -g1

%def_with wayland

%ifarch x86_64
%define bits 64
%endif
%ifarch %ix86
%define bits 32
%endif

Name: vulkan-amdgpu
Version: 2021.Q4.1
Release: alt1
License: MIT
Url: https://github.com/GPUOpen-Drivers/AMDVLK
Summary: AMD Open Source Driver For Vulkan
Group: System/X11

ExclusiveArch: %ix86 x86_64

Requires: vulkan-filesystem

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc9-c++ cmake python3-devel curl libstdc++9-devel libxcb-devel libssl-devel llvm-devel
BuildRequires: libX11-devel libxshmfence-devel libXrandr-devel spirv-headers libspirv-tools-devel libspirv-cross-devel glslang-devel
%if_with wayland
BuildRequires: wayland-devel libwayland-server-devel libwayland-client-devel libwayland-cursor-devel libwayland-egl-devel
BuildRequires: libffi-devel
%endif

Source0: xgl.tar
Source1: pal.tar
Source2: llpc.tar
Source3: spvgen.tar
Source4: llvm.tar
Source5: metrohash.tar
Source6: amd_icd.json
Source7: cwpack.tar

Patch1: spvgen-alt-shared.patch

%description
The AMD Open Source Driver for Vulkan(r) is an open-source Vulkan driver for
Radeon(tm) graphics adapters on Linux(r). It is built on top of AMD's Platform
Abstraction Library (PAL), a shared component that is designed to encapsulate
certain hardware and OS-specific programming details for many of AMD's 3D and
compute drivers. Leveraging PAL can help provide a consistent experience across
platforms, including support for recently released GPUs and compatibility with
AMD developer tools.

%prep
%setup -n xgl -b0 -b1 -b2 -b3 -b4 -b5 -b7
mkdir -p %_builddir/llvm-project
mv %_builddir/llvm %_builddir/llvm-project
pushd %_builddir/spvgen
%patch1 -p2
popd

%build
# FIXME! should be fixed in next build
%add_optflags -Wno-error=return-type

# build amdvlk.so
pushd %_builddir/xgl
export GCC_VERSION=9 \
%cmake \
	-DCMAKE_AR:PATH=%_bindir/gcc-ar \
	-DCMAKE_NM:PATH=%_bindir/gcc-nm \
	-DCMAKE_RANLIB:PATH=%_bindir/gcc-ranlib \
	-DCMAKE_BUILD_TYPE=Release \
%if_with wayland
	-DBUILD_WAYLAND_SUPPORT=ON \
%endif
        -DXGL_METROHASH_PATH=%_builddir/metrohash \
        -DXGL_CWPACK_PATH=%_builddir/cwpack \
        -DCMAKE_VERBOSE_MAKEFILE:BOOL=ON

%cmake_build
popd

%install
mkdir -p %buildroot{%_vkdir,%_libdir,%_sysconfdir/amd}
touch %buildroot%_sysconfdir/amd/amdPalSettings.cfg

install -p -m644 %_builddir/xgl/%_cmake__builddir/icd/%_vklib%bits.so %buildroot%_libdir/%_vklib.so
install -p -m644 %SOURCE6 %buildroot%_vkdir/amd_icd.json

%files
%_libdir/*.so
%_vkdir/*.json
%dir %_sysconfdir/amd
%ghost %attr(644,root,root) %config(missingok) %_sysconfdir/amd/*.cfg

%changelog
