%define wxbranch 2.8
%define ucode u
%def_enable java
%def_enable unicode
%def_enable mediactrl

%if_disabled unicode
%define ucode %{-E}
%endif

Name: wxGTK
Version: %wxbranch.12
Release: alt1.svn20131012.6
Serial:	2

Summary: The GTK+ port of the wxWidgets library
License: wxWidgets License
Group: System/Libraries
Url: http://wxwidgets.org
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar.gz
# reduces symbol list by ~10%, introduces ftbfs with perl 5.30/binutils 2.34
Source2: ld_shared_wrapper.pl

Patch1: wxGTK-disable-ABI-checking.patch
Patch2: wxGTK-ftbfs-gcc6.patch
Patch3: wxGTK-gstreamer1.0.patch

BuildPreReq: gcc-c++ libGL-devel libSDL-devel libSM-devel
BuildPreReq: libXt-devel libXinerama-devel libexpat-devel
BuildPreReq: libgtk+2-devel libjpeg-devel libtiff-devel
BuildPreReq: gstreamer1.0-devel gst-plugins1.0-devel
BuildPreReq: libGConf-devel

BuildPreReq: libstdc++-devel libpng-devel bakefile
BuildPreReq: libxml2-devel

%{?_enabled_java:BuildRequires: rpm-build-java}
%{?_enabled_mediactrl:BuildRequires: libesd-devel gstreamer-devel gst-plugins-devel}

Requires: lib%name = %{?serial:%serial:}%version-%release

%description
wxWidgets is a free C++ library for cross-platform GUI development.
With wxWidgets, you can create applications for different GUIs
(GTK+, Motif/LessTif, MS Windows, Mac) from the same source code.

This is a GTK+ port.

%package -n lib%name
Summary: Shared libraries of the GTK+ port of the wxWidgets
Group: System/Libraries
Requires: %name = %{?serial:%serial:}%version-%release

%description -n lib%name
wxWidgets is a free C++ library for cross-platform GUI development.
With wxWidgets, you can create applications for different GUIs
(GTK+, Motif/LessTif, MS Windows, Mac) from the same source code.

This package contains shared libraries of a GTK+ port.

%package -n lib%name-doc
Summary: Documentation for wxGTK library
Group: Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description -n lib%name-doc
Documentation for wxGTK, the GTK+ port of the wxWidgets library.

%package -n lib%name-devel
Summary: Development files for wxGTK library
Group: Development/C++
Provides: %name-devel = %version-%release
Conflicts: %name-devel < %version-%release
Obsoletes: %name-devel < %version-%release
Requires: %name = %{?serial:%serial:}%version-%release
Conflicts: wxGTK2-devel
Conflicts: wxGTK2u-devel

%description -n lib%name-devel
Header files for wxGTK, the GTK+ port of the wxWidgets library.

%package examples
Summary: wxGTK example programs
Group: Development/C++
BuildArch: noarch
Requires: %name-devel = %version
COnflicts: wxGTK2.9-examples
Conflicts: wxGTK2u-examples

%description examples
wxGTK example programs.

%package -n lib%name-contrib-stc
Summary: wxWidgets styled text control library
Group: System/Libraries
Provides: %name-contrib-stc = %{?serial:%serial:}%version-%release
Conflicts: %name-contrib-stc < %version-%release
Obsoletes: %name-contrib-stc < %version-%release
Requires: %name = %{?serial:%serial:}%version-%release

%description -n lib%name-contrib-stc
wxWidgets styled text control library.

%package -n lib%name-contrib-stc-devel
Summary: Development files for wxWidgets styled text control library
Group: Development/C++
Provides: %name-contrib-stc-devel = %version-%release
Conflicts: %name-contrib-stc-devel < %version-%release
Obsoletes: %name-contrib-stc-devel < %version-%release
Requires: lib%name-contrib-stc = %{?serial:%serial:}%version-%release

%description -n lib%name-contrib-stc-devel
Header files for wxWidgets styled text control library.

%package -n lib%name-contrib-gizmos
Summary: wxWidgets cell and canvas layout objects
Group: System/Libraries
Provides: %name-contrib-gizmos = %{?serial:%serial:}%version-%release
Conflicts: %name-contrib-gizmos < %version-%release
Obsoletes: %name-contrib-gizmos < %version-%release
Requires: %name = %{?serial:%serial:}%version-%release

%description -n lib%name-contrib-gizmos
wxWidgets cell and canvas layout objects.

%package -n lib%name-contrib-gizmos-devel
Summary: Development files for wxWidgets cell and canvas layout objects
Group: Development/C++
Provides: %name-contrib-gizmos-devel = %{?serial:%serial:}%version-%release
Conflicts: %name-contrib-gizmos-devel < %version-%release
Obsoletes: %name-contrib-gizmos-devel < %version-%release
Requires: lib%name-contrib-gizmos = %{?serial:%serial:}%version-%release

%description -n lib%name-contrib-gizmos-devel
Header files for wxWidgets cell and canvas layout objects.

%package -n lib%name-contrib-ogl
Summary: wxWidgets object graphics library
Group: System/Libraries
Provides: %name-contrib-ogl = %{?serial:%serial:}%version-%release
Conflicts: %name-contrib-ogl < %version-%release
Obsoletes: %name-contrib-ogl < %version-%release
Requires: %name = %{?serial:%serial:}%version-%release

%description -n lib%name-contrib-ogl
wxWidgets' Object Graphics Library (OGL) is a C++ library supporting the
creation and manipulation of simple and complex graphic images on a canvas.

%package -n lib%name-contrib-ogl-devel
Summary: Development files for wxWidgets object graphics library
Group: Development/C++
Provides: %name-contrib-ogl-devel = %version-%release
Conflicts: %name-contrib-ogl-devel < %version-%release
Obsoletes: %name-contrib-ogl-devel < %version-%release
Requires: lib%name-contrib-ogl = %{?serial:%serial:}%version-%release

%description -n lib%name-contrib-ogl-devel
Header files for wxWidgets object graphics library.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

subst "s,bakefile/presets,bakefile/presets-\$(WX_RELEASE),g" Makefile.in

%build
./autogen.sh
#autoreconf
%configure --without-odbc \
	 --without-debug_flag \
	 --without-debug_info \
	 --with-opengl \
	 --disable-joystick \
	 --enable-plugins \
	 --enable-precomp-headers=yes \
	 --enable-compat26 \
	 --with-xresources \
	 --enable-optimise \
	 --enable-shared \
	 --enable-unicode \
	 --enable-gtk2=yes \
	 --enable-soname \
	 %{subst_enable mediactrl} \
	 --enable-graphics_ctx \
	 --with-gnomeprint \
	 --with-sdl \
	 --with-regex=yes

%make_build

pushd contrib
%make_build
popd

%install

%makeinstall_std

ln -s %_libdir/wx/include/gtk2-unicode-release-%wxbranch/wx/setup.h \
	%buildroot%_includedir/wx-%wxbranch/wx
install -m644 version-script \
	%buildroot%_libdir/wx/config

pushd contrib
%makeinstall_std
#ln -s %_libdir/libwx_gtk2%{ucode}_mmedia-%wxbranch.so \
#	%buildroot%_libdir/libwx_gtk2%{ucode}_media-%wxbranch.so
popd

install -d %buildroot%_datadir/wx/examples/src
cp -a demos samples %buildroot%_datadir/wx/examples
for i in $(find %buildroot%_datadir/wx/examples -name Makefile)
do
	sed -i 's|^\(wx_top_builddir\).*|\1 =|' $i
	sed -i 's|^\(SAMPLES_RPATH_FLAG\).*|\1 =|' $i
	sed -i 's|^\(COND_wxUSE_REGEX_builtin___LIB_REGEX_p.*\)|#\1|' $i
	sed -i 's|^\(LIBDIRNAME\).*|\1 = %_libdir|' $i
	sed -i 's|^\(CXXFLAGS.*\)|\1 -I%_includedir/wx-%wxbranch|' $i
	sed -i 's|^\(CPPFLAGS.*\)|\1 -I%_includedir/wx-%wxbranch|' $i
	sed -i 's|\(/version\-script\)|%_libdir/wx/config\1|' $i
done

install -d %buildroot%_docdir/%name-%version
cp -fR docs/* %buildroot%_docdir/%name-%version/

%find_lang wxstd2%ucode

%files -f wxstd2%ucode.lang
%_datadir/bakefile/

%files -n lib%name
%_libdir/libwx_base%{ucode}-%wxbranch.so.*
%_libdir/libwx_base%{ucode}_net-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_adv-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_aui-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_richtext-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_core-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_html-%wxbranch.so.*
#_libdir/libwx_gtk2%{ucode}_mmedia-%wxbranch.so.*
%if_enabled mediactrl
%_libdir/libwx_gtk2%{ucode}_media-%wxbranch.so.*
%endif
%_libdir/libwx_gtk2%{ucode}_xrc-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_qa-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_fl-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_plot-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_svg-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_gl-%wxbranch.so.*
%if "%wxbranch" >= "2.5"
%_libdir/libwx_base%{ucode}_xml-%wxbranch.so.*
%endif

%files -n lib%name-doc
%doc %_docdir/%name-%version/

%files -n lib%name-devel
%_bindir/*
%_libdir/libwx_base%{ucode}-%wxbranch.so
%_libdir/libwx_base%{ucode}_net-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_adv-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_core-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_html-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_aui-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_richtext-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_fl-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_plot-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_svg-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_gl-%wxbranch.so
%_libdir/wx/%{wxbranch}/sound_sdl-%{wxbranch}.so
#_libdir/libwx_gtk2%{ucode}_mmedia-%wxbranch.so
%if_enabled mediactrl
%_libdir/libwx_gtk2%{ucode}_media-%wxbranch.so
%endif
%_libdir/libwx_gtk2%{ucode}_xrc-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_qa-%wxbranch.so
%if_enabled unicode
%_libdir/wx/config/gtk2-unicode-release-%wxbranch
%dir %_libdir/wx/include/gtk2-unicode-release-%wxbranch
%_libdir/wx/include/gtk2-unicode-release-%wxbranch/wx
%else
%_libdir/wx/config/gtk2-ansi-release-%wxbranch
%dir %_libdir/wx/include/gtk2-ansi-release-%wxbranch
%_libdir/wx/include/gtk2-ansi-release-%wxbranch/wx
%endif
%_libdir/wx/config/version-script
%_datadir/aclocal/*.m4
%dir %_includedir/wx-%wxbranch
%dir %_includedir/wx-%wxbranch/wx
%_includedir/wx-%wxbranch/wx/generic
%_includedir/wx-%wxbranch/wx/gtk
%_includedir/wx-%wxbranch/wx/html
%_includedir/wx-%wxbranch/wx/protocol
%_includedir/wx-%wxbranch/wx/unix
%_includedir/wx-%wxbranch/wx/xrc
%_includedir/wx-%wxbranch/wx/*.h
%_includedir/wx-%wxbranch/wx/*.cpp
%_includedir/wx-%wxbranch/wx/aui
%_includedir/wx-%wxbranch/wx/richtext
%_includedir/wx-%wxbranch/wx/fl
%_includedir/wx-%wxbranch/wx/plot
%_includedir/wx-%wxbranch/wx/svg
#_includedir/wx-%wxbranch/wx/mmedia
%if "%wxbranch" >= "2.5"
%_includedir/wx-%wxbranch/wx/xml
%_libdir/libwx_base%{ucode}_xml-%wxbranch.so
%endif

%files -n lib%name-contrib-stc
%_libdir/libwx_gtk2%{ucode}_stc-%wxbranch.so.*

%files -n lib%name-contrib-stc-devel
%_libdir/libwx_gtk2%{ucode}_stc-%wxbranch.so
%_includedir/wx-%wxbranch/wx/stc

%files -n lib%name-contrib-gizmos
%_libdir/libwx_gtk2%{ucode}_gizmos-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_gizmos_xrc-%wxbranch.so.*

%files -n lib%name-contrib-gizmos-devel
%_libdir/libwx_gtk2%{ucode}_gizmos-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_gizmos_xrc-%wxbranch.so
%_includedir/wx-%wxbranch/wx/gizmos

%files -n lib%name-contrib-ogl
%_libdir/libwx_gtk2%{ucode}_ogl-%wxbranch.so.*

%files -n lib%name-contrib-ogl-devel
%_libdir/libwx_gtk2%{ucode}_ogl-%wxbranch.so
%_includedir/wx-%wxbranch/wx/ogl

%files examples
%_datadir/wx/examples

%changelog
