Name: wxMaxima
Version: 23.03.0
Release: alt1

Summary: GUI for the computer algebra system Maxima
License: GPL-2.0+
Group: Sciences/Mathematics

Url: https://wxmaxima-developers.github.io/wxmaxima
Packager: Andrey Cherepanov <cas@altlinux.org>

Source0: %name-%version.tar
Source5: wxmaxima-ru.po.bz2
Patch:   %name-alt-help-path.patch

Requires: maxima

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
BuildRequires: ccache
BuildRequires: desktop-file-utils
BuildRequires: libappstream-glib
BuildRequires: libgomp-devel
BuildRequires: libpango-devel
BuildRequires: libwxGTK3.2-devel
BuildRequires: libxml2-devel
BuildRequires: makeinfo
BuildRequires: po4a doxygen
BuildRequires: zlib-devel

ExclusiveArch: %ix86 x86_64 armh aarch64 %e2k

Provides: wxmaxima = %EVR
Obsoletes: wxmaxima < %EVR

%description
wxMaxima is a wxWidgets GUI for the computer algebra system Maxima.

Since it is written with wxWidgets, it runs on multiple platforms
in native widget sets.  Most of maxima functions are accessible through
menus, some have dialogs.  The input line has command history (up-key,
down-key) and completion based on previous input (tab-key).
wxMaxima provides 2d formated display of maxima output.


%prep
%setup
#bzcat %SOURCE5 >locales/wxMaxima/ru.po
#patch -p1
%ifarch %e2k
# strip UTF-8 BOM for lcc < 1.24
find -type f -name '*.cpp' -o -name '*.h' | xargs -r sed -ri 's,^\xEF\xBB\xBF,,'
%endif

%build
%ifarch %e2k
# -std=c++03 by default as of lcc 1.23.12
%add_optflags -std=c++11
%endif
%cmake -GNinja
%ninja_build -C "%_cmake__builddir"

%install
%ninja_install -C "%_cmake__builddir"
# icons
install -pD -m644 data/wxmaxima-16.xpm %buildroot%_miconsdir/%name.xpm
install -pD -m644 data/wxmaxima-32.xpm %buildroot%_niconsdir/%name.xpm
%find_lang %name

%files -f %name.lang
%doc AUTHORS.md NEWS.md README.md
%_bindir/wxmaxima
%_desktopdir/*%name.desktop
%_niconsdir/%name.xpm
%_miconsdir/%name.xpm
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/bash-completion/completions/wxmaxima
%_datadir/mime/packages/x-wxmathml.xml
%_datadir/mime/packages/x-wxmaxima-batch.xml
%_docdir/wxmaxima/
%_man1dir/wxmaxima.1*
%_mandir/de/man1/wxmaxima.1*
%_pixmapsdir/*.xpm
%_pixmapsdir/*.png
%_pixmapsdir/*.svg
%_datadir/metainfo/*wxMaxima.appdata.xml

%changelog
